# coding=utf-8
# Copyright 2020 The Heteroscedastic Noisy Labels Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Lint as: python3
"""Utility functions for heteroscedastic_lib.py."""

from __future__ import absolute_import
from __future__ import division

from __future__ import print_function

import enum
import random

import tensorflow.compat.v2 as tf


class LogitNoise(enum.Enum):
  NORMAL = 1
  LOGISTIC = 2
  GUMBEL = 3


def gen_int_seed():
  return random.randrange(2**63 - 1)


def gen_tensor_seed():
  return tf.py_function(gen_int_seed, [], tf.int64)
