import numpy as np

import matplotlib.pyplot as plt

import holography

flip = True
use_dist = False # If this is true, run 'phase_calibration.m' in 'distort/' first

box_pattern = np.zeros((1080,1920))

box_pattern[300:400,300:400] = 1

dmd_pattern, sim_output = holography.binary_gs(box_pattern, ret=True, iters=10, use_dist=use_dist, flip=flip)



sim_output = (sim_output - sim_output.min()) / (sim_output.max() - sim_output.min())
plt.subplot(2, 1, 1)
plt.title("Simulated output")
if use_dist:
    plt.imshow(sim_output, vmin=0, vmax=5e-4)
else:
    plt.imshow(sim_output, vmin=0, vmax=1)
plt.subplot(2, 1, 2)
plt.title("DMD pattern")
plt.imshow(dmd_pattern)
plt.tight_layout()
plt.show()