import argparse
import typing


def get_train_parser():
    _line_drawing_mode = ['otsu_threshold', 'adaptive_threshold', 'canny', 'three_value_threshold', 'dilate-diff']

    parser = argparse.ArgumentParser()
    parser.add_argument('dataset_path')
    parser.add_argument('save_result_path')
    parser.add_argument('--num_dataset_test', required=True, type=int)
    parser.add_argument('--network_model', choices=['SimpleConvolution', 'LTBC'], default='LTBC')
    parser.add_argument('--batchsize', type=int, default=5)
    parser.add_argument('--size_image', type=int, default=128, help='size of input image')
    parser.add_argument('--augmentation', type=bool, default=False)
    parser.add_argument('--size_image_augmentation', type=int, default=None,
                        help='size of input image on data augmentation')
    parser.add_argument('--gpu', type=int, default=-1)
    parser.add_argument('--max_epoch', type=int, default=1000)
    parser.add_argument('--save_result_iteration', type=int, default=100,
                        help='iteration of saving trained model')
    parser.add_argument('--random_seed_test', type=int, default=None)
    parser.add_argument('--path_pretrained_model', default=None)
    parser.add_argument('--disable_ltbc_global', action='store_true')
    parser.add_argument('--line_drawing_mode', choices=_line_drawing_mode, default=None,
                        help='model of making line-drawing. if unspecified, gray scale image')
    parser.add_argument('--optimizer_adam_alpha', type=float, default=0.001)
    parser.add_argument('--weight_decay', type=float, default=None)
    parser.add_argument('--path_tag_list', type=str, help='path of json file written list of all labels')
    parser.add_argument('--path_tag_list_each_image', type=str, help='path of json file written labels each image')
    parser.add_argument('--blend_mse_color', type=float, default=1.0)
    parser.add_argument('--alpha_ltbc_classification', type=float, default=None,
                        help='alpha value of LTBC paper. if unspecified, without classification')
    parser.add_argument('--ltbc_classification_num_output_list', type=int, nargs='+', default=[256, 205],
                        help='number of nodes each layer of classification network.'
                             'last number should be same as number of labels')
    parser.add_argument('--use_histogram_network', action='store_true')
    parser.add_argument('--num_bins_histogram', type=int, default=85,
                        help='number of bins of color histogram')
    parser.add_argument('--threshold_histogram_palette', type=float, default=None,
                        help='the threshold of palette mode. if unspecified, histogram mode')
    parser.add_argument('--use_multidimensional_histogram', action='store_true',
                        help='using multidimensional histogram')
    parser.add_argument('--reinput_mode', type=str, choices=['color'], default=None)
    parser.add_argument('--loss_blend_ratio_reinput', type=float, nargs='+', default=[])
    parser.add_argument('--separate_backward_reinput', action='store_true')
    parser.add_argument('--separate_model_reinput', action='store_true')
    parser.add_argument('--use_residual_reinput', action='store_true')
    parser.add_argument('--ltbc_classification_loss_function', choices=['softmax', 'multi_label'], default='softmax')
    parser.add_argument('--max_pixel_drawing', type=int, default=None,
                        help='max number of colorize part for augmentation')
    parser.add_argument('--max_size_pixel_drawing', type=int, default=1,
                        help='max size of colorize part')
    parser.add_argument('--loss_type', type=str, default='RGB')
    parser.add_argument('--mse_loss_mode', choices=['color_space', 'before_sigmoid'], default='color_space')
    parser.add_argument('--use_adversarial_network', action='store_true',
                        help='adversarial training with discriminator')
    parser.add_argument('--blend_adversarial_generator', type=float, default=1.0)
    parser.add_argument('--discriminator_first_pooling_size', type=int, default=1,
                        help='size of pooling for discriminator\'s input image')
    parser.add_argument('--log_interval', type=int, default=10, help='number of logging interval iterations')
    parser.add_argument('--verbose', action='store_true', help='show loss')
    return parser

import pprint
parser = get_train_parser()
d = []
for key, value in vars(parser.parse_args()).items():
    # print(f'args.{key} = {value!r}')
    d.append((f'args.{key}', f'{value!r}'))
d.sort(key=lambda t: len(t[0]), reverse=True)
with open('/home/xxx/flowfarm/others/comi/modified/comicolorization/updater/multi_updater.py') as f:
    content = f.read()
for key, value in d:
    content = content.replace(key, value)
print(content)
    
'''
python bin/train.py \
    /path/to/images/directory \
    /path/to/save \
    --path_tag_list /path/to/label_ID_list.json \
    --path_tag_list_each_image /path/to/label_ID_list_for_each_image.json \
    --network_model LTBC \
    --num_dataset_test 1000 \
    --batchsize 30 \
    --size_image 224 \
    --augmentation True \
    --size_image_augmentation 256 \
    --save_result_iteration 1000 \
    --random_seed_test 0 \
    --loss_type Lab \
    --alpha_ltbc_classification 0.00333333333 \
    --ltbc_classification_loss_function multi_label \
    --line_drawing_mode otsu_threshold \
    --max_pixel_drawing 15 \
    --use_adversarial_network \
    --blend_adversarial_generator 1.0 \
    --discriminator_first_pooling_size 2 \
    --optimizer_adam_alpha 0.0001 \
    --blend_mse_color 1.0 \
    --mse_loss_mode color_space \
    --weight_decay 0.0001 \
    --log_interval 200 \
    --gpu -1 \
    --ltbc_classification_num_output_list 512 428 \  # last number should be same as number of labels
    --threshold_histogram_palette 0.0 \
    --use_histogram_network \
    --num_bins_histogram 6 \
    --use_multidimensional_histogram
'''