# How to set up the environment
```bash
$ conda create -n oc-cost python=3.7 -y
$ conda activate oc-cost
$ conda install pytorch==1.8.1 torchvision==0.9.1 cudatoolkit=10.1 -c pytorch
$ pip install openmim
$ mim install mmcv-full==1.3.10
$ mim install mmdet==2.15.0
$ pip install -r requirements.txt 
```
Make sure that your CUDA version and pytorch match.

## Dataset

To run evaluation on MS COCO, download COCO Detection Challenge 2017 validation split in the 'data' folder.

```
data
└── coco
    ├── annotations
    └── val2017
```

# Experiments

The following comand evaluates four off-the-shelf detectors on MS COCO validation 2017 using mAP and OC-cost.

```bash
$ PYTHONPATH='./' python src/tools/run_evaluation.py evaluate CocoOtcDataset outputs/run_evaluation/ --use-tuned-hparam
```

# Demo
We provide an minimal interactive notebook demo in `demo/interactive_oc_demo.ipynb` .

Dataset download and GPUs are not required for the demo.