import json
import time
import tempfile
import os,sys
from web3 import Web3, HTTPProvider
import pandas as pd
from brownie import Wei

generated_image="path to c2pa signed image generated using c2pa signed Dreambooth model"
blockchain_address = 'url to blockchain endpoint'
# Client instance to interact with the blockchain
web3 = Web3(HTTPProvider(blockchain_address))
rights_contract_abi=json.loads('') # path to local abi file of rights contract, otherwise can be pulled using web3py
nfts_contract_abi = json.loads('') # path to local abi file of NFT contract
user_address="0x..."
user_private_key="...."

def getManifestStore(fname):
  temp=tempfile.mktemp('.json', prefix='tmp', dir='/tmp')
  cmd="c2patool -d %s > %s" % (fname,temp)
  os.system(cmd)
  fp=open(temp,'rt')
  fcnt=fp.read()
  fp.close()
  try:
    mstore=json.loads(fcnt)
  except Exception as e:
    print(e)
  return mstore


def getIngredientsURIFromManifest(mstore):
  uri_list=[]
  names=[]
  unavailable=[]
  titles=[]
  m=mstore['manifests']
  manifests_list=list(m.keys())
  for manifest in manifests_list:

    if manifest == mstore['active_manifest']:
        continue

    m=mstore['manifests'][manifest]
    ast=m['assertion_store']

    #get the uri
    try:
        clm=ast["c2pa.asset-ref"]
    except:
        clm2=m['claim']
        title2=clm2['dc:title']
        unavailable.append(title2)
        continue

    ref=clm['references'][0]
    ref=ref['reference']
    uri=ref['uri']
    uri_list.append(uri)

    #get the name
    try:
        clm=ast["stds.schema-org.CreativeWork"]
    except:
        continue

    name=clm['author'][0]['name']
    names.append(name)

    clm3=m['claim']
    title=clm3['dc:title']
    titles.append(title)

  return uri_list, names, titles, unavailable   


def GetContractAddressTokenID(uri):
  smart_contract_address_list=[]
  tokenid_list=[]   

  for i in uri_list:
      uri=i.split('/')
      tokenid=uri[-1]
      tokenid=int(tokenid,16)
      x=uri[2].split(':')
      smart_contract_address=x[-1]
      smart_contract_address_list.append(smart_contract_address)
      tokenid_list.append(tokenid)

  return smart_contract_address_list, tokenid_list

manifest_store=getManifestStore(generated_image)

uri_list, names, titles, unavailable=getIngredientsURIFromManifest(manifest_store)

nft_contract_address_list, tokenid_list=GetContractAddressTokenID(uri_list)


data=pd.DataFrame({'name':names, 'tokenid':tokenid_list, 'contract_address':nft_contract_address_list, 'title':titles})
creators = data['name'].unique().tolist()
answer={}

print("The image at", generated_image, " has been created using", len(tokenid_list)+len(unavailable), "ingredients, of which",len(tokenid_list),"are available as NFTs.")
print("")

time.sleep(2)

print("They have been created by the following authors:", creators)


time.sleep(2)

for creator in creators:
    bycreator=data.loc[data['name'] == creator]
    works=bycreator['title'].tolist()
    print("")
    print("The works by", creator, "are", works)
    print("")
    time.sleep(2)
    print("Would you like to donate to", creator, "?")
    print("Type yes or no:")
    print("")
    answer[creator]=input()

for index, row in data.iterrows():
    if answer[row['name']] == 'no':
        continue
    
    nfts_contract=web3.eth.contract(address=row['contract_address'], abi=nfts_contract_abi)

    #get the owner of the token
    owner_address=nfts_contract.functions.ownerOf(row['tokenid']).call()

    rights_contract=web3.eth.contract(address=owner_address, abi=rights_contract_abi)

    block = web3.eth.get_block('latest')
    next_gas_price = block.get('baseFeePerGas') * 1.5
    gasprice=int(next_gas_price) 
    nonce = web3.eth.get_transaction_count(user_address)

    print(" ")
    print("How much would you like to donate? (in ETH)")
    value=input()
    value=value+" ether"
    print("")

    print("Sending transaction...")

    print("")

    donate=rights_contract.functions.donateToCreator().buildTransaction({
      "maxFeePerGas": gasprice,
      "maxPriorityFeePerGas":gasprice,
      "chainId":5,
      "from": user_address,
      "nonce": nonce,
      "value": Wei(value)})

    signed_transaction = web3.eth.account.sign_transaction(donate, private_key=user_private_key)
    transaction_hash=web3.eth.send_raw_transaction(signed_transaction.rawTransaction)
    transaction_receipt = web3.eth.wait_for_transaction_receipt(transaction_hash, timeout=600)
    print(transaction_receipt)
    print("")
    print("Successfully donated", value,"ETH to", row['name'], "for the content", row['title'])
    print("")

    nonce+=1
