import json
import time
import tempfile
import os,sys
from web3 import Web3, HTTPProvider


def getManifestStore(fname, destname):
  os.system("c2patool -d "+fname+" > "+ destname)
  fp=open(destname,'rt')
  fcnt=fp.read()
  fp.close()
  try:
    mstore=json.loads(fcnt)
  except Exception as e:
    print(e)
  return mstore

def recursiveFindAllEthAdx(mstore):
  wallets=[]
  names=[]
  m=mstore['manifests']
  manifests_list=list(m.keys())
  print(manifests_list)
  for manifest in manifests_list:

    if manifest == mstore['active_manifest']:
      continue

    m=mstore['manifests'][manifest]
    ast=m['assertions']
    ast1=ast[0]
    ast2=ast[1]

    try:
        if ast2['label']=='adobe.crypto.addresses':
            wallets.append(str(ast2['data']['ethereum'])[2:-2])
        else:
            continue
        if str(ast1['label'])=='stds.schema-org.CreativeWork':
            b=ast1['data']['author']
            b=b[0]
            names.append(b['name'])
        else:
            wallets=wallets.pop()
            continue

    except:
        continue

  return wallets,names

### MAIN ###

if __name__ == "__main__":
    if (len(sys.argv)==1):
        print('SYNTAX: donate.py in_manifest.c2pa out_manifest.json [optional ETH amount]')
        quit()

    eth=0
    if (len(sys.argv)>2):
        eth=float(sys.argv[3])

    fname=sys.argv[1]
    destname=sys.argv[2]
    
    # Get manifest store of synthetic image
    ms=getManifestStore(fname, destname)

    # Get contributors of concept image
    wallets,names=recursiveFindAllEthAdx(ms)

    #print(wallets,names)

    # Show contributors
    print('There were %d contributors to this generative art' % len(names))
    for (n,w) in zip(names,wallets):
      print('%s at %s' % (n,w))

    ## REWARD mode!
    if (eth>0):

       # We will pay..
       perperson=eth / len(w)
       print('Each contributor is getting %f ETH (of total %f)' % (perperson,eth))

       user_address="0x...." #addresses of "customers" who donate to author
       user_private_key="..."

       blockchain_address = 'blockchain endpoint url'
       web3 = Web3(Web3.HTTPProvider(blockchain_address))
       nonce = web3.eth.get_transaction_count(user_address)

       for (n,w) in zip(names,wallets):

          print("Initial balance of %s is %f" % (w,web3.fromWei(web3.eth.getBalance(w), 'ether')))

          block = web3.eth.get_block('latest')
          next_gas_price = block.get('baseFeePerGas') * 1.5
          gasprice=int(next_gas_price) 
          print('Paying %s' %w)

          tx = {
            'type': '0x2',
            'nonce': nonce,
            'from': user_address,
            'to': w,
            'value': web3.toWei(perperson, 'ether'),
            "maxFeePerGas": gasprice,
            "maxPriorityFeePerGas":gasprice,
            'chainId': 5
          }

          gas = web3.eth.estimateGas(tx)
          tx['gas'] = gas
          signed_tx = web3.eth.account.sign_transaction(tx, user_private_key)
          tx_hash = web3.eth.send_raw_transaction(signed_tx.rawTransaction)
          print("Transaction hash: " + str(web3.toHex(tx_hash)))
          time.sleep(5)

          print("Final balance of %s is %f" % (w,web3.fromWei(web3.eth.getBalance(w), 'ether')))
          nonce += 1
