import json
import pathlib
from web3 import Web3, HTTPProvider, middleware
import time
import pandas as pd
from web3.gas_strategies.time_based import medium_gas_price_strategy


# truffle development blockchain address
blockchain_address = 'blockchain endpoint url'

# Client instance to interact with the blockchain
web3 = Web3(HTTPProvider(blockchain_address))
web3.eth.set_gas_price_strategy(medium_gas_price_strategy)

contract_abi=json.loads('') #contract abi

# Fetch deployed contract reference

rights_contract_address='0x...' #contract address

#addresses of user
user_address="0x..."
user_private_key="...."

contentID=1 #content id of desired content
rightTypeTrain=1 #1 for train right, 2 for generate right in this demo, can be checked in the contract or use web3py to pull directly from blockchain using python
rightTypeGenerate=2

train_rightids=[]
generate_rightids=[]

contract = web3.eth.contract(address='0x...', abi=contract_abi)

block = web3.eth.get_block('latest')
next_gas_price = block.get('baseFeePerGas') * 1.5
gasprice=int(next_gas_price)

nonce_user=web3.eth.getTransactionCount(user_address)

#credit account of user

credituser = contract.functions.AddCredit().buildTransaction({
    "maxFeePerGas": gasprice,
    "maxPriorityFeePerGas":gasprice,
    "chainId":5,
    "from": user_address,
    "nonce": nonce_user,
    "value": 10000 })

signed_transaction = web3.eth.account.sign_transaction(credituser, private_key=user_private_key)
transaction_hash=web3.eth.send_raw_transaction(signed_transaction.rawTransaction)
transaction_receipt = web3.eth.wait_for_transaction_receipt(transaction_hash, timeout=600)

print(transaction_receipt)


block = web3.eth.get_block('latest')
next_gas_price = block.get('baseFeePerGas') * 1.5
gasprice=int(next_gas_price)

nonce_user=web3.eth.getTransactionCount(user_address)

buyTrainRight = contract.functions.BuyRightsFromCreator(contentID,rightTypeTrain).buildTransaction({
    "maxFeePerGas": gasprice,
    "maxPriorityFeePerGas":gasprice,
    "chainId":5,
    "from": user_address,
    "nonce": nonce_user,
})

signed_transaction = web3.eth.account.sign_transaction(buyTrainRight, private_key=user_private_key)
transaction_hash=web3.eth.send_raw_transaction(signed_transaction.rawTransaction)
transaction_receipt = web3.eth.wait_for_transaction_receipt(transaction_hash, timeout=600)
logs = contract.events.RightsSold().processReceipt(transaction_receipt)
print("User bought right to train from contract ", rights_contract_address, " for content", contentID)

#get unique right id from logs
log=logs[0]
log=log['args']
log=log['_rightsIntanceID']
train_rightids.append(log)

block = web3.eth.get_block('latest')
next_gas_price = block.get('baseFeePerGas') * 1.5
gasprice=int(next_gas_price)

nonce_user=web3.eth.getTransactionCount(user_address)

buyGenerateRight = contract.functions.BuyRightsFromCreator(contentID,rightTypeGenerate).buildTransaction({
    "maxFeePerGas": gasprice,
    "maxPriorityFeePerGas":gasprice,
    "chainId":5,
    "from": user_address,
    "nonce": nonce_user,
})

signed_transaction = web3.eth.account.sign_transaction(buyGenerateRight, private_key=user_private_key)
transaction_hash=web3.eth.send_raw_transaction(signed_transaction.rawTransaction)
transaction_receipt = web3.eth.wait_for_transaction_receipt(transaction_hash, timeout=600)
print("User bought right to generate from contract ", rights_contract_address, " for content", contentID)

logs = contract.events.RightsSold().processReceipt(transaction_receipt)
log=logs[0]
log=log['args']
log=log['_rightsIntanceID']

generate_rightids.append(log)

print(train_rightids)
print(generate_rightids)

#make a record of these








