#ifndef _BEZIER_H_
#define _BEZIER_H_

#include <math.h>

/* a Bezier surface path */

class CBezierSurface
{
public:
    CBezierSurface() {};
    ~CBezierSurface() {};

    /*
     *  evaluate the Bezier surface function
     *  z      - control points
     *  (u,v)  - input parameters
     */
    double value(double z[4][4], const double u, const double v)
    {
        double c[4];
        for (int i = 0; i < 4; i++)
        {
            c[i] = bezierCurve(z[i], u);
        }
        return bezierCurve(c, v);
    }

protected:
    /*
     *  evaluate the Bezier surface function
     *  z     - control points
     *  y     - input parameter
     */
    double bezierCurve(double z[4], double u) {

        //using the Bernstein polynomial
        
        return pow(1 - u, 3) * z[0] + 3 * u * pow(1 - u, 2) * z[1] +
            3 * pow(u, 2) * (1 - u) * z[2]
            + pow(u, 3) * z[3];

    }
    //control nets
    //double z[4][4] = { {1,2,0,1},{2,1,1,2},{1,2,2,1},{2,1,0,1} };
    //double z[4][4] = { {2, 1, 0, 1}, { 1,2,2,1 }, { 2,1,1,2 }, { 1,2,0,1 }};
    //double z[4][4] = { {1, 2, 0, 1}, { 1,2,0,1 }, { 1,2,0,1 }, { 1,2,0,1 } };
    //double z[4][4] = { {1, 0, 2, 1}, { 1,0,2,1 }, { 1,0,2,1 }, { 1,0,2,1 } };
};
#endif
