

-- In this file we do the elimination steps in the proofs of Cases 1, 2 and 3 in the K4 section of the Supplementary Material.

-- The below sends a bilinear form to its fundamental matrix.

To3by3Mat = (f) -> matrix{{coefficient(x_1*y_1,f),coefficient(x_1*y_2,f),coefficient(x_1*y_3,f)},
                          {coefficient(x_2*y_1,f),coefficient(x_2*y_2,f),coefficient(x_2*y_3,f)},
                          {coefficient(x_3*y_1,f),coefficient(x_3*y_2,f),coefficient(x_3*y_3,f)}}


-- n = 4, Case 1 ---------------------------------------------------------------------------------------------

-- u_ij = x_ij/y_ij

R = QQ[a_(1,1)..a_(4,3),u_12,u_13,u_14,u_23,u_24,u_34][x_1..x_3,y_1..y_3] 

-- The prescribed forms of the matrices.

P1=matrix{{0,a_(1,1),0,0},{0,0,a_(1,2),0},{0,0,0,a_(1,3)}} 
P2=matrix{{a_(2,1),0,0,0},{0,0,a_(2,2),0},{0,0,0,a_(2,3)}}
P3=matrix{{a_(3,1),0,0,0},{0,a_(3,2),0,0},{0,0,0,a_(3,3)}}
P4=matrix{{a_(4,1),0,0,0},{0,a_(4,2),0,0},{0,0,a_(4,3),0}}

-- The matrices whose determinants are the bilinear forms corresponding to fundamental matrices.

MAT12=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})|| 
      (P2|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT13=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT23=(P2|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT14=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT24=(P2|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT34=(P3|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})

-- We take the fundamental matrices to be on this form.

G12=matrix{{0,0,0},{0,0,u_12},{0,1,0}} 
G13=matrix{{0,0,u_13},{0,0,0},{0,1,0}}
G23=matrix{{0,0,u_23},{0,0,0},{1,0,0}}
G14=matrix{{0,0,u_14},{0,1,0},{0,0,0}}
G24=matrix{{0,0,u_24},{1,0,0},{0,0,0}}
G34=matrix{{0,u_34,0},{1,0,0},{0,0,0}}

-- We wish to put the fundamental matrices of Pi equal to G^{ij} (up to scale).
-- We take care of the scaling ambiguity by considering.

Dif12=(To3by3Mat(det MAT12))_(2,1)*G12-To3by3Mat(det MAT12) 
Dif13=(To3by3Mat(det MAT13))_(2,1)*G13-To3by3Mat(det MAT13)
Dif23=(To3by3Mat(det MAT23))_(2,0)*G23-To3by3Mat(det MAT23)
Dif14=(To3by3Mat(det MAT14))_(1,1)*G14-To3by3Mat(det MAT14)
Dif24=(To3by3Mat(det MAT24))_(1,0)*G24-To3by3Mat(det MAT24)
Dif34=(To3by3Mat(det MAT34))_(1,0)*G34-To3by3Mat(det MAT34)

IDif = ideal(Dif12,Dif13,Dif23,Dif14,Dif24,Dif34)

-- We remove parts with aij=0 and uij=0.

ISat = saturate(IDif,ideal(a_(1,3)*a_(2,3)*a_(3,3)*a_(4,3)))
ISat = saturate(ISat,ideal(a_(1,2)*a_(2,2)*a_(3,2)*a_(4,2)))
ISat = saturate(ISat,ideal(a_(1,1)*a_(2,1)*a_(3,1)*a_(4,1)))
ISat = saturate(ISat,ideal(u_12*u_13*u_23*u_14*u_24*u_34))

-- We eliminate aij.

IElim = eliminate({a_(1,1),a_(1,2),a_(1,3)},ISat)
IElim = eliminate({a_(2,1),a_(2,2),a_(2,3)},IElim)
IElim = eliminate({a_(3,1),a_(3,2),a_(3,3)},IElim)
IElim = eliminate({a_(4,1),a_(4,2),a_(4,3)},IElim) 

-- IElim is generated by the equation from the proof of Case 1.

-- n = 4, Case 2 --------------------------------------------------------------------------------------------------------------------------------

-- u_ij = x_ij/y_ij, v_ij=z_ij/y_ij

R = QQ[a_(1,1)..a_(4,3),u_12,u_13,u_14,u_23,u_24,u_34,v_12,v_13,v_14,v_23,v_24,v_34][x_1..x_3,y_1..y_3] 

P1=matrix{{0,1,0,a_(1,1)},{0,0,1,a_(1,2)},{0,0,0,a_(1,3)}}
P2=matrix{{1,0,0,a_(2,1)},{0,0,1,a_(2,2)},{0,0,0,a_(2,3)}}
P3=matrix{{1,0,0,a_(3,1)},{0,1,0,a_(3,2)},{0,0,0,a_(3,3)}}
P4=matrix{{1,0,-1,a_(4,1)},{0,1,-1,a_(4,2)},{0,0,0,a_(4,3)}}

MAT12=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P2|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT13=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT23=(P2|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT14=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT24=(P2|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT34=(P3|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})

G12 = matrix{{0,0,0},{0,0,u_12},{0,1,v_12}}
G13 = matrix{{0,0,u_13},{0,0,0},{0,1,v_13}}
G23 = matrix{{0,0,u_23},{0,0,0},{1,0,v_23}}
G14 = matrix{{0,0,u_14},{0,0,-u_14},{0,1,v_14}}
G24 = matrix{{0,0,u_24},{0,0,-u_24},{1,0,v_24}}
G34 = matrix{{0,0,u_34},{0,0,-u_34},{1,-1,v_34}}

Dif12=(To3by3Mat(det MAT12))_(2,1)*G12-To3by3Mat(det MAT12) 
Dif13=(To3by3Mat(det MAT13))_(2,1)*G13-To3by3Mat(det MAT13)
Dif23=(To3by3Mat(det MAT23))_(2,0)*G23-To3by3Mat(det MAT23)
Dif14=(To3by3Mat(det MAT14))_(2,1)*G14-To3by3Mat(det MAT14)
Dif24=(To3by3Mat(det MAT24))_(2,0)*G24-To3by3Mat(det MAT24)
Dif34=(To3by3Mat(det MAT34))_(2,0)*G34-To3by3Mat(det MAT34)

IDif = ideal(Dif12,Dif13,Dif23,Dif14,Dif24,Dif34)

ISat = saturate(IDif,ideal(a_(1,3)*a_(2,3)*a_(3,3)*a_(4,3)))
ISat = saturate(ISat,ideal(u_12*u_13*u_23*u_14*u_24*u_34))

IElim = eliminate({a_(1,1),a_(1,2),a_(1,3)},ISat)
IElim = eliminate({a_(2,1),a_(2,2),a_(2,3)},IElim)
IElim = eliminate({a_(3,1),a_(3,2),a_(3,3)},IElim)
IElim = eliminate({a_(4,1),a_(4,2),a_(4,3)},IElim) 

-- The conditions in the proof of Case 2 in terms of u_ij=x_ij/y_ij, v_ij=z_ij/y_ij are 
-- (#1) u_24*v_12-u_34*v_13+u_23*v_23-v_14+v_24-v_34, u_23*u_34+u_24, u_13*u_34+u_14, u_12*u_24+u_14, u_12*u_23+u_13.
-- In IElim, there are two additional generators: (#2) u_14*u_23-u_13*u_24 and u_13*u_14*v_12-u_12*u_14*v_13+u_12*u_13*v_14+
-- u_12*u_14*v_23-u_12*u_13*v_24+u_12*u_13*v_34.
-- However, if the conditions (#1) hold, then one can check that (#2) also hold.
-- In other words, the conditions from the proof of Case 2 are equivalent to the conditions of IElim.


-- n = 4, Case 3 ----------------------------------------------------------------------------------------------------------------------------

-- u_ij = x_ij/y_ij, v_ij=z_ij/y_ij

R = QQ[a_(1,1)..a_(4,3),b_1,b_2,b_3,u_12,u_13,u_14,u_23,u_24,u_34,v_12,v_13,v_14,v_23,v_24,v_34][x_1..x_3,y_1..y_3] 

P1=matrix{{0,1,0,a_(1,1)},{0,0,b_1,a_(1,2)},{0,0,0,a_(1,3)}}
P2=matrix{{1,0,0,a_(2,1)},{0,0,b_2,a_(2,2)},{0,0,0,a_(2,3)}}
P3=matrix{{1,-1,0,a_(3,1)},{0,0,b_3,a_(3,2)},{0,0,0,a_(3,3)}}
P4=matrix{{1,0,0,a_(4,1)},{0,1,0,a_(4,2)},{0,0,0,a_(4,3)}}


MAT12=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P2|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT13=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT23=(P2|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT14=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT24=(P2|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT34=(P3|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P4|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})


G12 = matrix{{0,0,0},{0,0,u_12},{0,1,v_12}}
G13 = matrix{{0,0,0},{0,0,u_13},{0,1,v_13}}
G23 = matrix{{0,0,0},{0,0,u_23},{0,1,v_23}}
G14 = matrix{{0,0,u_14},{0,0,0},{0,1,v_14}}
G24 = matrix{{0,0,u_24},{0,0,0},{1,0,v_24}}
G34 = matrix{{0,0,u_34},{0,0,0},{1,-1,v_34}}

Dif12=(To3by3Mat(det MAT12))_(2,1)*G12-To3by3Mat(det MAT12) 
Dif13=(To3by3Mat(det MAT13))_(2,1)*G13-To3by3Mat(det MAT13)
Dif23=(To3by3Mat(det MAT23))_(2,1)*G23-To3by3Mat(det MAT23)
Dif14=(To3by3Mat(det MAT14))_(2,1)*G14-To3by3Mat(det MAT14)
Dif24=(To3by3Mat(det MAT24))_(2,0)*G24-To3by3Mat(det MAT24)
Dif34=(To3by3Mat(det MAT34))_(2,0)*G34-To3by3Mat(det MAT34)

IDif = ideal(Dif12,Dif13,Dif23,Dif14,Dif24,Dif34)

ISat = saturate(IDif,ideal(a_(1,3)*a_(2,3)*a_(3,3)*a_(4,3)))
ISat = saturate(ISat,ideal(u_12*u_13*u_23*u_14*u_24*u_34))
ISat = saturate(ISat,ideal(b_1*b_2*b_3))

IElim = eliminate({a_(1,1),a_(1,2),a_(1,3)},ISat)
IElim = eliminate({a_(2,1),a_(2,2),a_(2,3)},IElim)
IElim = eliminate({a_(3,1),a_(3,2),a_(3,3)},IElim)
IElim = eliminate({a_(4,1),a_(4,2),a_(4,3)},IElim) 
IElim = eliminate({b_1,b_2,b_3},IElim) 

-- The equations of Case 3 in terms of u_ij=x_ij/y_ij, v_ij=z_ij/y_ij are 
-- (#1) u_12*u_23+u_13, u_13*u_34+u_14,u_12*u_24+u_14, u_12*u_23+u_13.
-- In IElim, there is one additional generator: (#2) u_13*v_12+v_13-v_23.
-- However, if the conditions (#1) hold, then one can check that (#2) also hold.
-- In other words, conditions from the proof of Case 3 are equivalent to the conditions of IElim.

