
-- This code was used for the proof of Theorem 3.16 in the Supplementary Material. 


-- The below sends a bilinear form to its fundamental matrix.

To3by3Mat = (f) -> matrix{{coefficient(x_1*y_1,f),coefficient(x_1*y_2,f),coefficient(x_1*y_3,f)},
                          {coefficient(x_2*y_1,f),coefficient(x_2*y_2,f),coefficient(x_2*y_3,f)},
                          {coefficient(x_3*y_1,f),coefficient(x_3*y_2,f),coefficient(x_3*y_3,f)}}

-- n = 3, collinear setting ----------------------------------------------------------------------------------------------

R = QQ[a_12,a_13,a_23,b_12,b_13,b_23,c_12,c_13,c_23,d_12,d_13,d_23,lam]

-- We first find the IRank ideal.

G12 = matrix{{0,0,0},{0,a_12,b_12},{0,c_12,d_12}}
G13 = matrix{{0,0,0},{0,a_13,b_13},{0,c_13,d_13}}
G23 = matrix{{0,0,0},{0,a_23,b_23},{0,c_23,d_23}} 

ZER = 0*id_(QQ^3)

ThreeView = (ZER|G12|G13)||(transpose(G12)|ZER|lam*G23)||(
            transpose(G13)|lam*transpose(G23)|ZER)

-- Rank condition. 

IMinors = minors(5,ThreeView) 

-- Saturation step.

IMinorsSat = saturate(IMinors,ideal(lam))

-- Rank-deficieny conditions.

rd12 = a_12*d_12-b_12*c_12 
rd13 = a_13*d_13-b_13*c_13 
rd23 = a_23*d_23-b_23*c_23 

IMinorsSat = saturate(IMinorsSat,ideal(rd12))
IMinorsSat = saturate(IMinorsSat,ideal(rd13))
IMinorsSat = saturate(IMinorsSat,ideal(rd23))

-- This is the IRank ideal:

IRank = IMinorsSat

-- We second find the JStar ideal.

GStarPrime = matrix{{c_12,-a_12},{d_12,-b_12}}*matrix{{a_13,b_13},{c_13,d_13}} 
G23Prime = matrix{{a_23,b_23},{c_23,d_23}} 

-- We wish to put the GStarPrime equal to G23Prime (up to scale).

JRed = ideal(G23Prime_(0,0)*GStarPrime-G23Prime*GStarPrime_(0,0),G23Prime_(1,0)*GStarPrime-G23Prime*GStarPrime_(1,0),
          G23Prime_(0,1)*GStarPrime-G23Prime*GStarPrime_(0,1),G23Prime_(1,1)*GStarPrime-G23Prime*GStarPrime_(1,1))

-- JStar is the appropriate component:

JStar = ( primaryDecomposition JRed )_(1)

-- IRank and JStar are the same

IRank == JStar -- prints true


-- n = 3, non-collinear setting -------------------------------------------------------------------------------------------

R = QQ[x_12,x_13,x_23,y_12,y_13,y_23,z_12,z_13,z_23,w_12,w_13,w_23,lam]

-- We first find the IRank ideal.

G12 = matrix{{0,0,0},{0,x_12,y_12},{0,z_12,w_12}}
G13 = matrix{{0,x_13,y_13},{0,0,0},{0,z_13,w_13}}
G23 = matrix{{x_23,0,y_23},{0,0,0},{z_23,0,w_23}} 

ZER = 0*id_(QQ^3)

ThreeView = (ZER|G12|G13)||(transpose(G12)|ZER|lam*G23)||(
            transpose(G13)|lam*transpose(G23)|ZER)

IMinors = minors(7,ThreeView) 

IMinorsSat = saturate(IMinors,ideal(lam))

rd12 = x_12*w_12-y_12*z_12 
rd13 = x_13*w_13-y_13*z_13 
rd23 = x_23*w_23-y_23*z_23 

IMinorsSat = saturate(IMinorsSat,ideal(rd12))
IMinorsSat = saturate(IMinorsSat,ideal(rd13))
IMinorsSat = saturate(IMinorsSat,ideal(rd23))

IRank = IMinorsSat 

-- IRank is generated by x_12,x_13,x_23.

-- Conversely, define a new ring:

R = QQ[a_(1,1)..a_(4,3),u_1..u_3,v_1..v_3][x_1..x_3,y_1..y_3]

-- We define cameras on the appropriate form:

P1=matrix{{0,a_(1,1),0,u_1},{0,0,a_(1,2),v_1},{0,0,0,a_(1,3)}}
P2=matrix{{a_(2,1),0,0,u_2},{0,0,a_(2,2),v_2},{0,0,0,a_(2,3)}}
P3=matrix{{a_(3,1),0,0,u_3},{0,a_(3,2),0,v_3},{0,0,0,a_(3,3)}}

-- Contruct the 6 x 6 matrices that will get us the fundamental matrices.

MAT12=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P2|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT13=(P1|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})
MAT23=(P2|matrix{{x_1},{x_2},{x_3}}|matrix{{0},{0},{0}})||
      (P3|matrix{{0},{0},{0}}|matrix{{y_1},{y_2},{y_3}})

-- Compute the fundamental matrices.

F12=To3by3Mat(det MAT12)
F13=To3by3Mat(det MAT13)
F23=To3by3Mat(det MAT23)

-- Observe that the degrees of freedom in the cameras means that any fundamental matrices on the form G12,G13,G23 with 
-- x_12,x_13,x_23 = 0 are compatible.


-- n = 4, Case 1 ------------------------------------------------------------------------------------------------------------

-- u_ij=x_ij/y_ij

R = QQ[u_12,u_13,u_14,u_23,u_24,u_34,lam_1,lam_2,lam_3] 

G12 = matrix{{0,0,0},{0,0,u_12},{0,1,0}}
G13 = matrix{{0,0,u_13},{0,0,0},{0,1,0}}
G14 = matrix{{0,0,u_14},{0,1,0},{0,0,0}}

G23 = matrix{{0,0,u_23},{0,0,0},{1,0,0}}
G24 = matrix{{0,0,u_24},{1,0,0},{0,0,0}}
G34 = matrix{{0,u_34,0},{1,0,0},{0,0,0}}

ZER = 0*id_(QQ^3)

FourView = (ZER|G12|G13|G14)||(transpose(G12)|ZER|lam_1*G23|lam_2*G24)||(
      transpose(G13)|lam_1*transpose(G23)|ZER|lam_3*G34)||(
      transpose(G14)|lam_2*transpose(G24)|lam_3*transpose(G34)|ZER)

IMinors = minors(7,FourView)

ISat = saturate(IMinors,ideal(lam_1*lam_2*lam_3))
ISat = saturate(ISat,ideal(u_12*u_13*u_14*u_23*u_24*u_34))
IElim = eliminate({lam_1,lam_2,lam_3},ISat)

IRank = IElim

-- IRank is generated by the equation from the proof of Case 1.
