function [] = demo()

    frameSize = [480, 270]; % in pixels

    % Intrinsics
    f = 385.8824; % Focal length in pixels
    principalPoint = [242.2764, 128.5360]; % in pixels (if unknown, use frameSize./2 )

    % Method's parameters
    binSize = 0.001; % in rad
    maxAngle = 0.07; % in rad
    spatialStep = 15; % in pixels

    % Precompute step
    % Get coordinates of the flow vectors
    flowLocations = getFlowLocations(frameSize, principalPoint, spatialStep);
    % Get the directions of the lines of compatible rotations
    precomputedLines = precomputeLines(flowLocations, binSize, maxAngle, f);

    % Load the optical flow
    flow = load('flow_example.mat');

    % Sample and expand the flow with the locations of the flow vectors
    flow = flowConvertor(flow, flowLocations, spatialStep);

    % Estimate the rotation
    estRotation(flow, precomputedLines, binSize, maxAngle, f)

end
