function flow = flowConvertor(input_flow, flowLocations, spatialStep)
    % flowConvertor
    %   input_flow    - Struct with fields uv: [HxWx2 double]
    %   flowLocations - Coords of the flow vectors, Struct with fields X: [HxW double], Y: [HxW double]
    %   spatialStep   - Number of pixels to skip while sampling the flow (double)
    %
    % RETURNS
    %   flow    - Flow structure with fields X, Y, Dx, and Dy

    flow.X = flowLocations.X;
    flow.Y = flowLocations.Y;
    flow.Dx = input_flow.uv(1:spatialStep:end, 1:spatialStep:end, 1);
    flow.Dy = input_flow.uv(1:spatialStep:end, 1:spatialStep:end, 2);
