function nCubicOpt=CubicNormalOPT(A,P1,P2,u1,v1,u2,v2,ptsCorr,affCorr)

p1=[u1;v1];
p2=[u2;v2];


if (ptsCorr==1)
	F=ComputeFundamentalFromProjections(P1,P2);
	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2]);
	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));
else
	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
end

if (affCorr==1)
    [A]=GetClosestConsistentAffineTransform(A, F, p1(1:2), p2(1:2));
end






	gradU1=CalculateGradientsForU(P1,p1(1),pt3D(1),pt3D(2),pt3D(3));
	gradV1=CalculateGradientsForV(P1,p1(2),pt3D(1),pt3D(2),pt3D(3));

	gradU2=CalculateGradientsForU(P2,p2(1),pt3D(1),pt3D(2),pt3D(3));
	gradV2=CalculateGradientsForV(P2,p2(2),pt3D(1),pt3D(2),pt3D(3));


%	p1=cross(gradV1,gradU2);
%	p2=cross(gradU2,gradU1);
%	p3=cross(gradV1,gradV2);
%	p4=cross(gradV2,gradU1);
%	p5=cross(gradV1,gradU1);

	a1=A(1,1);
	a2=A(1,2);
	a3=A(2,1);
	a4=A(2,2);

%	AS=[a1,a2,a3,a4];

	as=[A(1,1);A(1,2);A(2,1);A(2,2)];

	Ws=[cross(gradV1,gradU2)';cross(gradU2,gradU1)';cross(gradV1,gradV2)';cross(gradV2,gradU1)';cross(gradV1,gradU1)'];


%	w11=p1(1);
%    w12=p1(2);
%    w13=p1(3);

%    w21=p2(1);
%    w22=p2(2);
%    w23=p2(3);

%    w31=p3(1);
%    w32=p3(2);
%    w33=p3(3);

%    w41=p4(1);
%    w42=p4(2);
%    w43=p4(3);

%    w51=p5(1);
%    w52=p5(2);
%    w53=p5(3);

    for idx=1:4

        g(idx)=as(idx)*Ws(5,1)-Ws(idx,1);
        h(idx)=as(idx)*Ws(5,2)-Ws(idx,2);
        j(idx)=as(idx)*Ws(5,3)-Ws(idx,3);

        k(idx)=Ws(5,1)*Ws(idx,2)-Ws(5,2)*Ws(idx,1);
        l(idx)=Ws(5,1)*Ws(idx,3)-Ws(5,3)*Ws(idx,1);

        m(idx)=Ws(5,2)*Ws(idx,3)-Ws(5,3)*Ws(idx,2);

    end %for

sum_hk=0.0;
sum_hl=0.0;
sum_kj=0.0;
sum_jl=0.0;
sum_gk=0.0;
sum_gl=0.0;
sum_gm=0.0;
sum_hm=0.0;
sum_jm=0.0;

for idx=1:4

    sum_hk=sum_hk+h(idx)*k(idx);
    sum_hl=sum_hl+h(idx)*l(idx);
    sum_kj=sum_kj+k(idx)*j(idx);
    sum_jl=sum_jl+j(idx)*l(idx);
    sum_gk=sum_gk+g(idx)*k(idx);
    sum_gl=sum_gl+g(idx)*l(idx);

    sum_gm=sum_gm+g(idx)*m(idx);
    sum_hm=sum_hm+h(idx)*m(idx);
    sum_jm=sum_jm+j(idx)*m(idx);

end %for


%A=sum_hk;
%B=sum_gk;
%C=sum_gl;
%D=sum_kj
%E=sum_hl
%F=sum_jl;

%G=sum_gm
%H=sum_hm
%I=sum_jm

poly1=[sum_hk;sum_kj+sum_hl;sum_jl];
poly2=[sum_gk;sum_gl];

finalPoly=-sum_gk*conv(poly1,poly1)+sum_hk*[conv(poly1,poly2);0.0]+(sum_kj-sum_gm)*[0.0;conv(poly1,poly2)]+sum_hm*[0.0;conv(poly2,poly2);0.0]+sum_jm*[0.0;0.0;conv(poly2,poly2)];


a=finalPoly(2);
b=finalPoly(3);
c=finalPoly(4);
d=finalPoly(5);


bv=b/a;
cv=c/a;
dv=d/a;

p=cv-bv*bv/3;
q=dv-cv*bv/3+2*bv*bv*bv/27;

SQ=sqrt(q*q/4+p*p*p/27);

n2Est=nthroot(-q/2-SQ,3)+nthroot(-q/2+SQ,3)-bv/3;
n1Est=-(sum_hk*n2Est*n2Est+(sum_kj+sum_hl)*n2Est+sum_jl)/(sum_gk*n2Est+sum_gl);

nCubicOpt=[n1Est;n2Est;1.0];
nCubicOpt=nCubicOpt/norm(nCubicOpt);

end
