%Parameter type
%
%0 General stereo
% 1 pure planar (rot+translate direction)
% 2 Quadrocopter: (rot + arbitrary translate in 3D) 
% 3 Moto
% 4 planar: sideways motion  (translation only in horizontal cooordinate)
% 5 planar: forward motion  (translation only in direction perpendicular to image plane)


%intrinsicsType
%0: nothing special (general camera)
%1: general camera with zero skew
%2: camera with common vertical and horizontal focal length
%3: camera with common vertical and horizontal focal length plus zero principal point
%4: eigenmatrix (for normalized cameras)


% DiffCamera: 1: common intrinsics 2: different intrinsics

function [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(type,intrinsicsType,DiffCameras)
  
  TRANSLATE_LENGTH=3.0;
  
  
  if (DiffCameras==1)
    C1=GenerateIntrinsics(intrinsicsType);
    C2=C1;
  elseif (DiffCameras==2)
    C1=GenerateIntrinsics(intrinsicsType);
    C2=GenerateIntrinsics(intrinsicsType);
  end  

  %Default:
  R1=eye(3);
  t1=zeros(3,1);
  
  if (type==0) %general stereo camera
    t2=randn(3,1);
    t2=t2/norm(t2);
    t2=TRANSLATE_LENGTH*t2;
    [R2,tmp1,tmp2]=svd(randn(3));
  elseif (type==1) %planar motion
    t1=-(TRANSLATE_LENGTH)*(1.0+0.2*randn)*[0.0;0.0;-1.0];
%    t1=[0.0;0.0;-2.0-2.0*randn];
    angle=rand*pi/3.0;  %0-60 degree)
    angleTmp=pi/2.0-angle;
    t2=TRANSLATE_LENGTH*(1.0+0.2*randn)*[-sin(angleTmp);0;-cos(angleTmp)];
    R2=[cos(angle),0,-sin(angle);0,1,0;sin(angle),0,cos(angle)]';
    t2=-R2*t2;
  elseif (type==2)
    t2=TRANSLATE_LENGTH*randn(3,1);
    angle=rand*2*pi;
    R2=[cos(angle),0,sin(angle);0,1,0;-sin(angle),0,cos(angle)];
  elseif (type==3)
    t2=TRANSLATE_LENGTH*[randn();0;randn()];
    angle1=rand*2*pi;
    angle2=rand*2*pi;
    tmpR1=[cos(angle1),0,sin(angle1);0,1,0;-sin(angle1),0,cos(angle2)];
    tmpR2=[cos(angle2),-sin(angle2),0;sin(angle2),cos(angle2),0;0,0,1];
    R2=tmpR2*tmpR1;
  elseif (type==4) %planar sideways
    t1=-(TRANSLATE_LENGTH)*(1.0+0.2*randn)*[0.0;0.0;-1.0];
%    t1=[0.0;0.0;-2.0-2.0*randn];
    t2=t1+[randn*TRANSLATE_LENGTH;0;0];
    R2=R1;
  elseif (type==5) %planar + forward
    t1=-(TRANSLATE_LENGTH)*(1.0+0.2*randn)*[0.0;0.0;-1.0];
%    t1=[0.0;0.0;-2.0-2.0*randn];
    t2=t1+[randn*TRANSLATE_LENGTH;0;0];
    R2=R1;
  end %if
  
  
  P1=C1*[R1,t1];
  P2=C2*[R2,t2];
  
  R=R2*R1';
  t=t2-R2*R1'*t1;
  
  Tx=[0,-t(3),t(2);t(3),0,-t(1);-t(2),t(1),0];
  
  EGT=Tx*R;
  
  end
