function normalVector=NormalFromHomography(u1,v1,u2,v2,A,C1,C2,R,t,affCorr)


p1=inv(C1)*[u1;v1;1.0];
p2=inv(C2)*[u2;v2;1.0];


fu1=C1(1,1);
fv1=C1(2,2);

fu2=C2(1,1);
fv2=C2(2,2);


A(1,1)=fu1*A(1,1)/fu2;
A(2,1)=fu1*A(2,1)/fv2;
A(1,2)=fv1*A(1,2)/fu2;
A(2,2)=fv1*A(2,2)/fv2;


if (affCorr==1)
    F=[0,-t(3),t(2);t(3),0,-t(1);-t(2),t(1),0]*R;
    [A]=GetClosestConsistentAffineTransform(A, F, [p1(1);p1(2)], [p2(1);p2(2)]);
end


    x1=p1(1)
    x2=p1(2)
    y1=p2(1)
    y2=p2(2)

    tx=t(1)
    ty=t(2)
    tz=t(3)


    r1=R(1,1)
    r2=R(2,1)
    r3=R(3,1)

    r4=R(1,2)
    r5=R(2,2)
    r6=R(3,2)

    r7=R(1,3)
    r8=R(2,3)
    r9=R(3,3)


    a1=A(1,1)
    a2=A(2,1)
    a3=A(1,2)
    a4=A(2,2)


    M =[
    [    tx*x1 - tz*x1*y1,     tx*x2 - tz*x2*y1, tx - tz*y1],
    [    ty*x1 - tz*x1*y2,     ty*x2 - tz*x2*y2, ty - tz*y2],
    [tx - tz*(y1 + a1*x1),            -a1*tz*x2,     -a1*tz],
    [ty - tz*(y2 + a2*x1),            -a2*tz*x2,     -a2*tz],
    [           -a3*tz*x1, tx - tz*(y1 + a3*x2),     -a3*tz],
    [           -a4*tz*x1, ty - tz*(y2 + a4*x2),     -a4*tz]]


    b =[
    r9*y1 - r1*x1 - r4*x2 - r7 + r3*x1*y1 + r6*x2*y1;
    r9*y2 - r2*x1 - r5*x2 - r8 + r3*x1*y2 + r6*x2*y2;
            a1*r9 - r1 + r3*(y1 + a1*x1) + a1*r6*x2;
            a2*r9 - r2 + r3*(y2 + a2*x1) + a2*r6*x2;
            a3*r9 - r4 + r6*(y1 + a3*x2) + a3*r3*x1;
            a4*r9 - r5 + r6*(y2 + a4*x2) + a4*r3*x1]

    normalVector=pinv(M)*b;
    normalVector=normalVector/norm(normalVector);

end
