function intersections=spec_kvadratikus(B1,C1,D1,E1,F1,A2,C2,D2,E2,F2)

%x^{4}:B_{1}A_{2}^{2}-C_{1}A_{2}C_{2}
%x^{3}:2B_{1}A_{2}D_{2}-C_{1}A_{2}E_{2}-C_{1}D_{2}C_{2}+D_{1}C_{2}^{2}-E_{1}A_{2}C_{2}
%x^{2}:B_{1}D_{2}^{2}+2B_{1}A_{2}F_{2}-C_{1}D_{2}E_{2}-C_{1}F_{2}C_{2}+2D_{1}C_{2}E_{2}-E_{1}A_{2}E_{2}-E_{1}D_{2}C_{2}+F_{1}C_{2}^{2}
%x^{1}:2B_{1}A_{2}F_{2}-C_{1}F_{2}E_{2}+D_{1}E_{2}^{2}-E_{1}D_{2}E_{2}-E_{1}F_{2}C_{2}+2F_{1}C_{2}E_{2}
%x^{0}:B_{1}F_{2}^{2}-E_{1}F_{2}E_{2}+F_{1}E_{2}^{2}

	threshold=max(abs([B1,C1,D1,E1,F1,A2,C2,D2,E2,F2]))/1e5;

	x4=B1*A2*A2-C1*A2*C2;
	x3=2*B1*A2*D2-C1*A2*E2-C1*D2*C2+D1*C2*C2-E1*A2*C2;
	x2=B1*D2*D2+2*B1*A2*F2-C1*D2*E2-C1*F2*C2+2*D1*C2*E2-E1*A2*E2-E1*D2*C2+F1*C2*C2;
	x1=2*B1*D2*F2-C1*F2*E2+D1*E2*E2-E1*D2*E2-E1*F2*C2+2*F1*C2*E2;
	x0=B1*F2*F2-E1*F2*E2+F1*E2*E2;

	intersections=[];
	rs=roots([x4,x3,x2,x1,x0]);

	for i=1:size(rs)
		if (isreal(rs(i)))
			x=rs(i);
			y=-(A2*x*x+D2*x+F2)/(C2*x+E2);
			
			check1=B1*y*y+C1*x*y+D1*x+E1*y+F1;
			check2=A2*x*x+C2*x*y+D2*x+E2*y+F2;
			
            if ((abs(check1)<threshold)&&(abs(check2)<threshold))
				intersections(size(intersections,1)+1,:)=[x,y];
            end %if
    	end %if
       end %for

end
%
%B1,C1,D1,E1,F1,A2,C2,D2,E2,F2
%spec_kvardatikus(1,0,-1,0,0,1,0,0,-1,0)
%spec_kvardatikus(1,0,0,0,-9,1,0,0,0,-9)

%for i=1:100000
%	if (size(kvardatikus(rand,rand,rand,rand,rand,rand,rand,rand,rand,rand,rand,rand))!=0)
%	pause
%	endif
%endfor
