#include "HartleySturm.h"

using namespace cv;
using namespace std;

pair<Point2d,Point2d> HartleySturmTriangulation(Mat F,Point2d pt1,Point2d pt2){


//	T1=[1,0,-u1(1);0,1,-u1(2);0,0,1];

    
    Mat T1=Mat::zeros(3,3,CV_64F);
    T1.at<double>(0,0)=1.0;
    T1.at<double>(1,1)=1.0;
    T1.at<double>(2,2)=1.0;
    
    
    T1.at<double>(0,2)=-1.0*pt1.x;
    T1.at<double>(1,2)=-1.0*pt1.y;

    
//	T2=[1,0,-v1(1);0,1,-v1(2);0,0,1];

    Mat T2=Mat::zeros(3,3,CV_64F);
    T2.at<double>(0,0)=1.0;
    T2.at<double>(1,1)=1.0;
    T2.at<double>(2,2)=1.0;
    
    
    T2.at<double>(0,2)=-1.0*pt2.x;
    T2.at<double>(1,2)=-1.0*pt2.y;


    
    
//	F2=inv(T2')*F*inv(T1);
    
    Mat F2=T2.t().inv()*F*T1.inv();

    

//    [tmpU,tmpS,tmpV]=svd(F2)
    
    
    Mat tmpU,tmpS,tmpVT;

    SVDecomp(F2, tmpS, tmpU, tmpVT, cv::SVD::FULL_UV);    
    
    Point3d e1;
    Point3d e2;
    
//	e1=tmpV(:,3);
    
    e1.x=tmpVT.at<double>(2,0);
    e1.y=tmpVT.at<double>(2,1);
    e1.z=tmpVT.at<double>(2,2);

    
//	e2=tmpU(:,3);
    
    e2.x=tmpU.at<double>(0,2);
    e2.y=tmpU.at<double>(1,2);
    e2.z=tmpU.at<double>(2,2);

    
//	s1=e1(1)^2+e1(2)^2;
//	s2=e2(1)^2+e2(2)^2;

	double s1=e1.x*e1.x+e1.y*e1.y;
	double s2=e2.x*e2.x+e2.y*e2.y;

//	e1/s1; ??
//	e2/s1; ??
    
    
//	R1=[e1(1),e1(2),0;-e1(2),e1(1),0;0,0,1];
    
    Mat R1=Mat::zeros(3,3,CV_64F);
    
    R1.at<double>(0,0)=e1.x;
    R1.at<double>(0,1)=e1.y;

    R1.at<double>(1,0)=-e1.y;
    R1.at<double>(1,1)=e1.x;

    R1.at<double>(2,2)=1.0;

//	R2=[-e2(1),-e2(2),0;e2(2),-e2(1),0;0,0,1];

    Mat R2=Mat::zeros(3,3,CV_64F);
    
    R2.at<double>(0,0)=-e2.x;
    R2.at<double>(0,1)=-e2.y;

    R2.at<double>(1,0)=e2.y;
    R2.at<double>(1,1)=-e2.x;

    R2.at<double>(2,2)=1.0;
    

//	F3=R2*F2*R1';
	
	Mat F3=R2*F2*(R1.t());


    /*
	f1=e1(3);
	f2=e2(3);
	a=F3(2,2);
	b=F3(2,3);
	c=F3(3,2);
	d=F3(3,3);
	*/
    
	double f1=e1.z;
	double f2=e2.z;
	double a=F3.at<double>(1,1);
	double b=F3.at<double>(1,2);
	double c=F3.at<double>(2,1);
	double d=F3.at<double>(2,2);

    
//	%Create polinomial:
//	t6=-a*c*(f1^4)*(a*d-b*c);
//	t5=(a*a+f2*f2*c*c)^2-(a*d+b*c)*(f1^4)*(a*d-b*c);
//	t4=2*(a*a+f2*f2*c*c)*(2*a*b+2*c*d*f2*f2)-d*b*(f1^4)*(a*d-b*c)-2*a*c*f1*f1*(a*d-b*c);
//	t3=(2*a*b+2*c*d*f2*f2)^2+2*(a*a+f2*f2*c*c)*(b*b+f2*f2*d*d)-2*f1*f1*(a*d-b*c)*(a*d+b*c);
//	t2=2*(2*a*b+2*c*d*f2*f2)*(b*b+f2*f2*d*d)-2*(f1*f1*a*d-f1*f1*b*c)*b*d-a*c*(a*d-b*c);
//	t1=(b*b+f2*f2*d*d)^2-(a*d+b*c)*(a*d-b*c);
//	t0=-(a*d-b*c)*b*d;
    

	double t6=-a*c*f1*f1*f1*f1*(a*d-b*c);
	double t5=(a*a+f2*f2*c*c)*(a*a+f2*f2*c*c)-(a*d+b*c)*(f1*f1*f1*f1)*(a*d-b*c);
	double t4=2*(a*a+f2*f2*c*c)*(2*a*b+2*c*d*f2*f2)-d*b*(f1*f1*f1*f1)*(a*d-b*c)-2*a*c*f1*f1*(a*d-b*c);
	double t3=(2*a*b+2*c*d*f2*f2)*(2*a*b+2*c*d*f2*f2)+2*(a*a+f2*f2*c*c)*(b*b+f2*f2*d*d)-2*f1*f1*(a*d-b*c)*(a*d+b*c);
	double t2=2*(2*a*b+2*c*d*f2*f2)*(b*b+f2*f2*d*d)-2*(f1*f1*a*d-f1*f1*b*c)*b*d-a*c*(a*d-b*c);
	double t1=(b*b+f2*f2*d*d)*(b*b+f2*f2*d*d)-(a*d+b*c)*(a*d-b*c);
	double t0=-(a*d-b*c)*b*d;

    

    Mat companion=Mat::zeros(6,6,CV_64F);
    
    companion.at<double>(1,0)=1.0;
    companion.at<double>(2,1)=1.0;
    companion.at<double>(3,2)=1.0;
    companion.at<double>(4,3)=1.0;
    companion.at<double>(5,4)=1.0;
    
    companion.at<double>(0,5)=-1.0*t0/t6;
    companion.at<double>(1,5)=-1.0*t1/t6;
    companion.at<double>(2,5)=-1.0*t2/t6;
    companion.at<double>(3,5)=-1.0*t3/t6;
    companion.at<double>(4,5)=-1.0*t4/t6;
    companion.at<double>(5,5)=-1.0*t5/t6;
    
    
    EigenvalueDecomposition evd(companion);
    Mat roots=evd.eigenvalues();


//	bestS=inf;
    
    double bestT;
    double bestS=INFINITY;
    //  double bestS=9999999999.999;
    
    for (int idx=0;idx<6;idx++){
        double currRoot=roots.at<double>(0,idx);
        double val=currRoot*currRoot/(1+f1*f1*currRoot*currRoot)+((c*currRoot+d)*(c*currRoot+d))/((a*currRoot+b)*(a*currRoot+b)+f2*f2*((c*currRoot+d)*(c*currRoot+d)));
        
        if (val<bestS){
            bestS=val;
            bestT=currRoot;
        }
        

        
//			val=calculateS(currRoot,a,b,c,d,f1,f2);
//        function ret=calculateS(t,a,b,c,d,f1,f2)
//        ret=t*t/(1+f1*f1*t*t)+((c*t+d)^2)/((a*t+b)^2+f2*f2*((c*t+d)^2));
//endfunction





//			if (val<bestS)
//				bestS=val;
//				bestT=currRoot;
//			end
        
    }

    

        
//	point1=[0;bestT;1];
        
    Mat point1(3,1,CV_64F);
    point1.at<double>(0,0)=0.0;
    point1.at<double>(1,0)=bestT;
    point1.at<double>(2,0)=1.0;
    
    
    
//	line2=F3*point1;
    
    Mat line2=F3*point1;
    
    
    
//	point2=[-line2(1)*line2(3);-line2(2)*line2(3);line2(1)^2+line2(2)^2];
    
    Mat point2(3,1,CV_64F);
    point2.at<double>(0,0)=-1.0*line2.at<double>(0,0)*line2.at<double>(2,0);
    point2.at<double>(1,0)=-1.0*line2.at<double>(1,0)*line2.at<double>(2,0);
    point2.at<double>(2,0)=line2.at<double>(0,0)*line2.at<double>(0,0)+line2.at<double>(1,0)*line2.at<double>(1,0);

    
    
//	point2/=point2(3);

    point2=(1.0/point2.at<double>(2,0))*point2;


    
//	u2=inv(R1*T1)*point1;
    
    Mat u2=(R1*T1).inv()*point1;

    
//	v2=inv(R2*T2)*point2;
    
    Mat v2=(R2*T2).inv()*point2;
     
   
    /*

    
    





%	bestS
	valInf=1/(f1^2)+(c^2)/(a^2+f2^2*c^2);
	if (valInf<bestS)
		"Serious error"
		exit;
	end

    
 */   
    
    cout <<u2;
    
    Point2d res1;
    res1.x=u2.at<double>(0,0)/u2.at<double>(2,0);
    res1.y=u2.at<double>(1,0)/u2.at<double>(2,0);
    
    Point2d res2;
    res2.x=v2.at<double>(0,0)/v2.at<double>(2,0);
    res2.y=v2.at<double>(1,0)/v2.at<double>(2,0);
    
    
    pair<Point2d,Point2d> res;
    
    res.first=res1;
    res.second=res2;
    
    return res;
}


/*

int main(int argc, char** argv){

    
//F=[   0.365396   0.782107   0.567914;    0.431668   0.595504   0.249948 ;    0.040076   0.069467   0.586869 ]

    
Mat F(3,3,CV_64F);

F.at<double>(0,0)=0.365396;
F.at<double>(0,1)=0.782107;
F.at<double>(0,2)=0.567914;

F.at<double>(1,0)=0.431668;
F.at<double>(1,1)=0.595504;
F.at<double>(1,2)=0.249948;

F.at<double>(2,0)=0.040076;
F.at<double>(2,1)=0.069467;
F.at<double>(2,2)=0.586869;

Point2d u1;
u1.x=1.0;
u1.y=2.0;

Point2d v1;
v1.x=3.0;
v1.y=4.0;

pair<Point3d,Point3d> hsres=HartleySturmTriangulation(F,u1,v1);

cout << hsres.first <<endl;
cout << hsres.second <<endl;
    
}

*/
