#include "NormalEstimation.h"

//From Eigen lib
#include <eigen3/unsupported/Eigen/Polynomials>



Point3f cross(Point3f vec1,Point3f vec2){
    Point3f ret;
    
    ret.x=vec1.y*vec2.z-vec1.z*vec2.y;
    ret.y=vec1.z*vec2.x-vec1.x*vec2.z;
    ret.z=vec1.x*vec2.y-vec1.y*vec2.x;
    
    return ret;
}


Point3f CubicOpt(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2){
/*
    Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);

    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);

    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);


	F=ComputeFundamentalFromProjections(P1,P2);
	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2]);
	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));

	gradU1=CalculateGradientsForU(P1,u1,pt3D(1),pt3D(2),pt3D(3));
	gradV1=CalculateGradientsForV(P1,v1,pt3D(1),pt3D(2),pt3D(3));

	gradU2=CalculateGradientsForU(P2,u2,pt3D(1),pt3D(2),pt3D(3));
	gradV2=CalculateGradientsForV(P2,v2,pt3D(1),pt3D(2),pt3D(3));
*/




/*
function F=ComputeFundamentalFromProjections(P1,P2)
        e1=null(P1);
        e2=P2*e1;

        e2x=[0,-e2(3),e2(2);e2(3),0,-e2(1);-e2(2),e2(1),0];
        F=e2x*P2*pinv(P1);
endfunction

*/

    //Null vector of P1:


    Mat P1_3(3,3,CV_32F);
    Mat P4(3,1,CV_32F);

    P1_3.at<float>(0,0)=P1.at<float>(0,0);
    P1_3.at<float>(0,1)=P1.at<float>(0,1);
    P1_3.at<float>(0,2)=P1.at<float>(0,2);

    P1_3.at<float>(1,0)=P1.at<float>(1,0);
    P1_3.at<float>(1,1)=P1.at<float>(1,1);
    P1_3.at<float>(1,2)=P1.at<float>(1,2);

    P1_3.at<float>(2,0)=P1.at<float>(2,0);
    P1_3.at<float>(2,1)=P1.at<float>(2,1);
    P1_3.at<float>(2,2)=P1.at<float>(2,2);

    P4.at<float>(0,0)=P1.at<float>(0,3);
    P4.at<float>(1,0)=P1.at<float>(1,3);
    P4.at<float>(2,0)=P1.at<float>(2,3);

    Mat e1=-1.0f*(P1_3.inv())*P4;

    Mat e1Hom(4,1,CV_32F);

    e1Hom.at<float>(0,0)=e1.at<float>(0,0);
    e1Hom.at<float>(1,0)=e1.at<float>(1,0);
    e1Hom.at<float>(2,0)=e1.at<float>(2,0);
    e1Hom.at<float>(3,0)=1.0f;


    Mat e2=P2*e1Hom;

    Mat e2x(3,3,CV_32F);

    e2x.at<float>(0,0)=0.0f;
    e2x.at<float>(0,1)=-1.0f*e2.at<float>(2,0);
    e2x.at<float>(0,2)=e2.at<float>(1,0);

    e2x.at<float>(1,0)=e2.at<float>(2,0);
    e2x.at<float>(1,1)=0.0f;
    e2x.at<float>(1,2)=-1.0f*e2.at<float>(0,0);

    e2x.at<float>(2,0)=-1.0f*e2.at<float>(1,0);
    e2x.at<float>(2,1)=e2.at<float>(0,0);
    e2x.at<float>(2,2)=0.0f;

    Mat F=e2x*P2*P1.t()*((P1*P1.t()).inv());

cout <<"Hhhhhmmmmm:\n" << endl;

    //Convert F to <double> as HartleySturm requires more bits due to numerical issues

    Mat Fdouble(3,3,CV_64F);

    Fdouble.at<double>(0,0)=F.at<float>(0,0);
    Fdouble.at<double>(0,1)=F.at<float>(0,1);
    Fdouble.at<double>(0,2)=F.at<float>(0,2);

    Fdouble.at<double>(1,0)=F.at<float>(1,0);
    Fdouble.at<double>(1,1)=F.at<float>(1,1);
    Fdouble.at<double>(1,2)=F.at<float>(1,2);

    Fdouble.at<double>(2,0)=F.at<float>(2,0);
    Fdouble.at<double>(2,1)=F.at<float>(2,1);
    Fdouble.at<double>(2,2)=F.at<float>(2,2);


    Point2d p1Orig((double)u1,(double)v1);
    Point2d p2Orig((double)u2,(double)v2);


    pair<Point2d,Point2d> HSPoint=HartleySturmTriangulation(Fdouble,p1Orig,p2Orig);

    Point3f pt3D=LinearTriangulation(P1,HSPoint.first.x,HSPoint.first.y,P2,HSPoint.second.x,HSPoint.second.y);

/*
    cout <<"pt3D:\n" << pt3D <<endl;
    cout <<"F:\n" << F <<endl;
cout <<"Hhhhhmmmmm:\n" << endl;

    cout <<"P1Orig:\n" << p1Orig <<endl;
    cout <<"HS1:\n" << HSPoint.first <<endl;


    cout <<"P2Orig:\n" << p2Orig <<endl;
    cout <<"HS2:\n" << HSPoint.second <<endl;
*/


    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);



    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);



cout <<"Hhhhhmmmmm:\n" << endl;

//	p1=cross(gradV1,gradU2);
//	p2=cross(gradU2,gradU1);
//	p3=cross(gradV1,gradV2);
//	p4=cross(gradV2,gradU1);
//	p5=cross(gradV1,gradU1);

    cout <<"A:"<<A << endl;
    cout <<"pt3D" << pt3D <<endl;


    Point3f p1=cross(gradV1,gradU2);
    Point3f p2=cross(gradU2,gradU1);
    Point3f p3=cross(gradV1,gradV2);
    Point3f p4=cross(gradV2,gradU1);
    Point3f p5=cross(gradV1,gradU1);




//	as=[A(1,1);A(1,2);A(2,1);A(2,2)];


    Mat as(4,1,CV_32F);
    as.at<float>(0,0)=A.at<float>(0,0);
    as.at<float>(1,0)=A.at<float>(0,1);
    as.at<float>(2,0)=A.at<float>(1,0);
    as.at<float>(3,0)=A.at<float>(1,1);



//	Ws=[cross(gradV1,gradU2)';cross(gradU2,gradU1)';cross(gradV1,gradV2)';cross(gradV2,gradU1)';cross(gradV1,gradU1)'];

    Mat Ws(5,3,CV_32F);

    Ws.at<float>(0,0)=p1.x;
    Ws.at<float>(0,1)=p1.y;
    Ws.at<float>(0,2)=p1.z;

    Ws.at<float>(1,0)=p2.x;
    Ws.at<float>(1,1)=p2.y;
    Ws.at<float>(1,2)=p2.z;

    Ws.at<float>(2,0)=p3.x;
    Ws.at<float>(2,1)=p3.y;
    Ws.at<float>(2,2)=p3.z;

    Ws.at<float>(3,0)=p4.x;
    Ws.at<float>(3,1)=p4.y;
    Ws.at<float>(3,2)=p4.z;

    Ws.at<float>(4,0)=p5.x;
    Ws.at<float>(4,1)=p5.y;
    Ws.at<float>(4,2)=p5.z;

cout <<"Hhhhhmmmmm:\n" << endl;
    cout <<"Ws:\n" << Ws << endl;

    
/*
    for idx=1:4

        g(idx)=as(idx)*Ws(5,1)-Ws(idx,1);
        h(idx)=as(idx)*Ws(5,2)-Ws(idx,2);
        j(idx)=as(idx)*Ws(5,3)-Ws(idx,3);

        k(idx)=Ws(5,1)*Ws(idx,2)-Ws(5,2)*Ws(idx,1)
        l(idx)=Ws(5,1)*Ws(idx,3)-Ws(5,3)*Ws(idx,1)

        m(idx)=Ws(5,2)*Ws(idx,3)-Ws(5,3)*Ws(idx,2)

    endfor
*/
cout <<"Hhhhhmmmmm:\n" << endl;


    Mat g(4,1,CV_32F);
    Mat h(4,1,CV_32F);
    Mat j(4,1,CV_32F);
    Mat k(4,1,CV_32F);
    Mat l(4,1,CV_32F);
    Mat m(4,1,CV_32F);

    for (int idx=0;idx<4;idx++){
        g.at<float>(idx,0)=as.at<float>(idx,0)*Ws.at<float>(4,0)-Ws.at<float>(idx,0);
        h.at<float>(idx,0)=as.at<float>(idx,0)*Ws.at<float>(4,1)-Ws.at<float>(idx,1);
        j.at<float>(idx,0)=as.at<float>(idx,0)*Ws.at<float>(4,2)-Ws.at<float>(idx,2);

        k.at<float>(idx,0)=Ws.at<float>(4,0)*Ws.at<float>(idx,1)-Ws.at<float>(4,1)*Ws.at<float>(idx,0);
        l.at<float>(idx,0)=Ws.at<float>(4,0)*Ws.at<float>(idx,2)-Ws.at<float>(4,2)*Ws.at<float>(idx,0);

        m.at<float>(idx,0)=Ws.at<float>(4,1)*Ws.at<float>(idx,2)-Ws.at<float>(4,2)*Ws.at<float>(idx,1);

    }

    cout <<"g:\n" << g <<endl;
    cout <<"h:\n" << h <<endl;
    cout <<"j:\n" << j <<endl;
    cout <<"k:\n" << k <<endl;
    cout <<"l:\n" << l <<endl;
    cout <<"m:\n" << m <<endl;

    /*
sum_hk=0.0;
sum_hl=0.0;
sum_kj=0.0;
sum_jl=0.0;
sum_gk=0.0;
sum_gl=0.0;
sum_gm=0.0;
sum_hm=0.0;
sum_jm=0.0;

*/

float sum_hk=0.0;
float sum_hl=0.0;
float sum_kj=0.0;
float sum_jl=0.0;
float sum_gk=0.0;
float sum_gl=0.0;
float sum_gm=0.0;
float sum_hm=0.0;
float sum_jm=0.0;



/*
for idx=1:4

    sum_hk+=h(idx)*k(idx);
    sum_hl+=h(idx)*l(idx);
    sum_kj+=k(idx)*j(idx);
    sum_jl+=j(idx)*l(idx);
    sum_gk+=g(idx)*k(idx);
    sum_gl+=g(idx)*l(idx);

    sum_gm+=g(idx)*m(idx);
    sum_hm+=h(idx)*m(idx);
    sum_jm+=j(idx)*m(idx);

endfor
*/




for(int idx=0;idx<4;idx++){

    sum_hk+=h.at<float>(idx,0)*k.at<float>(idx,0);
    sum_hl+=h.at<float>(idx,0)*l.at<float>(idx,0);
    sum_kj+=k.at<float>(idx,0)*j.at<float>(idx,0);
    sum_jl+=j.at<float>(idx,0)*l.at<float>(idx,0);
    sum_gk+=g.at<float>(idx,0)*k.at<float>(idx,0);
    sum_gl+=g.at<float>(idx,0)*l.at<float>(idx,0);

    sum_gm+=g.at<float>(idx,0)*m.at<float>(idx,0);
    sum_hm+=h.at<float>(idx,0)*m.at<float>(idx,0);
    sum_jm+=j.at<float>(idx,0)*m.at<float>(idx,0);
}



printf("sum_hk : %f \n",sum_hk);
printf("sum_hl : %f \n",sum_hl);
printf("sum_kj : %f \n",sum_kj);
printf("sum_jl : %f \n",sum_jl);
printf("sum_gk : %f \n",sum_gk);
printf("sum_gl : %f \n",sum_gl);

printf("sum_gm : %f \n",sum_gm);
printf("sum_hm : %f \n",sum_hm);
printf("sum_jm : %f \n",sum_jm);


//poly1=[sum_hk;sum_kj+sum_hl;sum_jl]
//poly2=[sum_gk;sum_gl]


vector<float> poly1,poly2;

poly1.push_back(sum_hk);
poly1.push_back(sum_kj+sum_hl);
poly1.push_back(sum_jl);

poly2.push_back(sum_gk);
poly2.push_back(sum_gl);


printf("Poly1: %f %f %f\n",(double)poly1[0],(double)poly1[1],(double)poly1[2]);

printf("Poly2: %f %f \n",(double)poly2[0],(double)poly2[1]);

//finalPoly=-sum_gk*conv(poly1,poly1)+sum_hk*[conv(poly1,poly2);0.0]+(sum_kj-sum_gm)*[0.0;conv(poly1,poly2)]+sum_hm*[0.0;conv(poly2,poly2);0.0]+sum_jm*[0.0;0.0;conv(poly2,poly2)];

vector<float> poly1_square=PolyConv(poly1,poly1);
vector<float> poly2_square=PolyConv(poly2,poly2);
vector<float> poly12=PolyConv(poly1,poly2);


vector<float> firstPoly=PolyMul(poly1_square,-1.0f*sum_gk);
vector<float> secondPoly=PolyMul(PolyShift(poly12,1),sum_hk);;

vector<float> thirdPoly=PolyMul(PolyAddZeroElements(poly12,1),sum_kj-sum_gm);


vector<float> fourthPoly=PolyMul(PolyShift(PolyAddZeroElements(poly2_square,1),1),sum_hm);

vector<float> fifthPoly=PolyMul(PolyAddZeroElements(poly2_square,2),sum_jm);

printf("firstPoly: %f %f %f %f %f\n",(double)firstPoly[0],(double)firstPoly[1],(double)firstPoly[2],(double)firstPoly[3],(double)firstPoly[4]);
printf("secondPoly: %f %f %f %f %f\n",(double)secondPoly[0],(double)secondPoly[1],(double)secondPoly[2],(double)secondPoly[3],(double)secondPoly[4]);
printf("thirdPoly: %f %f %f %f %f\n",(double)thirdPoly[0],(double)thirdPoly[1],(double)thirdPoly[2],(double)thirdPoly[3],(double)thirdPoly[4]);
printf("fourthPoly: %f %f %f %f %f\n",(double)fourthPoly[0],(double)fourthPoly[1],(double)fourthPoly[2],(double)fourthPoly[3],(double)fourthPoly[4]);
printf("fifthPoly: %f %f %f %f %f \n",(double)fifthPoly[0],(double)fifthPoly[1],(double)fifthPoly[2],(double)fifthPoly[3],(double)fifthPoly[4]);


vector<float> finalPoly=PolyAdd(firstPoly,PolyAdd(secondPoly,PolyAdd(thirdPoly,PolyAdd(fourthPoly,fifthPoly))));

printf("finalPoly: %f %f %f %f %f \n",(double)finalPoly[0],(double)finalPoly[1],(double)finalPoly[2],(double)finalPoly[3],(double)finalPoly[4]);





/*




a=finalPoly(2);
b=finalPoly(3);
c=finalPoly(4);
d=finalPoly(5);

bv=b/a;
cv=c/a;
dv=d/a;

p=cv-bv*bv/3;
q=dv-cv*bv/3+2*bv*bv*bv/27;

SQ=sqrt(q*q/4+p*p*p/27);

*/

float a=finalPoly[1];
float b=finalPoly[2];
float c=finalPoly[3];
float d=finalPoly[4];


float bv=b/a;
float cv=c/a;
float dv=d/a;


float p=cv-bv*bv/3;
float q=dv-cv*bv/3+2*bv*bv*bv/27;

float SQ=sqrtf(q*q/4.0f+p*p*p/27.0f);



/*




n2Est=nthroot(-q/2-SQ,3)+nthroot(-q/2+SQ,3)-bv/3;
n1Est=-(sum_hk*n2Est*n2Est+(sum_kj+sum_hl)*n2Est+sum_jl)/(sum_gk*n2Est+sum_gl);

nCubicOpt=[n1Est;n2Est;1.0];

*/

float n2Est=std::cbrt(-q/2-SQ)+std::cbrt(-q/2+SQ)-bv/3;
float n1Est=-(sum_hk*n2Est*n2Est+(sum_kj+sum_hl)*n2Est+sum_jl)/(sum_gk*n2Est+sum_gl);


float finalScale=sqrtf(n1Est*n1Est+n2Est*n2Est+1.0f);

Point3f normal;
normal.x=n1Est/finalScale;
normal.y=n2Est/finalScale;
normal.z=1.0f/finalScale;

return normal;


}//end CubicOpt


Point3f FNE1(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2){

/*
 * %V1.0:
	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);

%V2.0:
%	F=ComputeFundamentalFromProjections(P1,P2)
%	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2])
%	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));


	gradU1=CalculateGradientsForU(P1,u1,pt3D(1),pt3D(2),pt3D(3))
	gradV1=CalculateGradientsForV(P1,v1,pt3D(1),pt3D(2),pt3D(3))

	gradU2=CalculateGradientsForU(P2,u2,pt3D(1),pt3D(2),pt3D(3))
	gradV2=CalculateGradientsForV(P2,v2,pt3D(1),pt3D(2),pt3D(3))

	p=A(2,2)*cross(gradV1,gradU2)-A(1,1)*cross(gradV2,gradU1); %a4*w1-a1*w4
	q=A(2,1)*cross(gradU2,gradU1)-A(1,2)*cross(gradV1,gradV2); %a3*w2-a2*w3
	v=cross(p,q);

	n=v/norm(v);
	
	*/

    

    Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
    
    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);
    
    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);
    
    
    Point3f crossV1U2=cross(gradV1,gradU2);
    Point3f crossV2U1=cross(gradV2,gradU1);
    Point3f crossU2U1=cross(gradU2,gradU1);
    Point3f crossV1V2=cross(gradV1,gradV2);
    

    
    
    Point3f p,q;
    
    p.x=A.at<float>(1,1)*crossV1U2.x-A.at<float>(0,0)*crossV2U1.x;
    p.y=A.at<float>(1,1)*crossV1U2.y-A.at<float>(0,0)*crossV2U1.y;
    p.z=A.at<float>(1,1)*crossV1U2.z-A.at<float>(0,0)*crossV2U1.z;
    
    q.x=A.at<float>(1,0)*crossU2U1.x-A.at<float>(0,1)*crossV1V2.x;
    q.y=A.at<float>(1,0)*crossU2U1.y-A.at<float>(0,1)*crossV1V2.y;
    q.z=A.at<float>(1,0)*crossU2U1.z-A.at<float>(0,1)*crossV1V2.z;
    
    
	Point3f n=cross(p,q);

    float length=sqrt(n.x*n.x+n.y*n.y+n.z*n.z);
    
	n.x/=length;
	n.y/=length;
	n.z/=length;

    return n;

}



Point3f FNE2(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2){

/*
 *%V1.0:
	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);

%V2.0:
%	F=ComputeFundamentalFromProjections(P1,P2)
%	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2])
%	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));

	gradU1=CalculateGradientsForU(P1,u1,pt3D(1),pt3D(2),pt3D(3));
	gradV1=CalculateGradientsForV(P1,v1,pt3D(1),pt3D(2),pt3D(3));

	gradU2=CalculateGradientsForU(P2,u2,pt3D(1),pt3D(2),pt3D(3));
	gradV2=CalculateGradientsForV(P2,v2,pt3D(1),pt3D(2),pt3D(3));


        p=A(2,2)*cross(gradV1,gradV2)-A(2,1)*cross(gradV2,gradU1); %a4*w3-a3*w4
        q=A(1,1)*cross(gradU2,gradU1)-A(1,2)*cross(gradV1,gradU2); %a1*w2-a2*w1
	v=cross(p,q);

	n=v/norm(v);

	
	*/


    Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
    
    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);
    
    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);
    
    
    Point3f crossV1U2=cross(gradV1,gradU2);
    Point3f crossV2U1=cross(gradV2,gradU1);
    Point3f crossU2U1=cross(gradU2,gradU1);
    Point3f crossV1V2=cross(gradV1,gradV2);
    

    
    
    Point3f p,q;
    
    p.x=A.at<float>(1,1)*crossV1V2.x-A.at<float>(1,0)*crossV2U1.x;
    p.y=A.at<float>(1,1)*crossV1V2.y-A.at<float>(1,0)*crossV2U1.y;
    p.z=A.at<float>(1,1)*crossV1V2.z-A.at<float>(1,0)*crossV2U1.z;
    
    q.x=A.at<float>(0,0)*crossU2U1.x-A.at<float>(0,1)*crossV1U2.x;
    q.y=A.at<float>(0,0)*crossU2U1.y-A.at<float>(0,1)*crossV1U2.y;
    q.z=A.at<float>(0,0)*crossU2U1.z-A.at<float>(0,1)*crossV1U2.z;
    
    
	Point3f n=cross(p,q);

    float length=sqrt(n.x*n.x+n.y*n.y+n.z*n.z);
    
	n.x/=length;
	n.y/=length;
	n.z/=length;

    return n;

}


Point3f FNE3(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2){

/*
 *%V1.0:
	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);

%V2.0:
%	F=ComputeFundamentalFromProjections(P1,P2)
%	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2])
%	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));

	gradU1=CalculateGradientsForU(P1,u1,pt3D(1),pt3D(2),pt3D(3));
	gradV1=CalculateGradientsForV(P1,v1,pt3D(1),pt3D(2),pt3D(3));

	gradU2=CalculateGradientsForU(P2,u2,pt3D(1),pt3D(2),pt3D(3));
	gradV2=CalculateGradientsForV(P2,v2,pt3D(1),pt3D(2),pt3D(3));


        p=A(2,2)*cross(gradU2,gradU1)-A(1,2)*cross(gradV2,gradU1); %a4*w2-a2*w4
        q=A(1,1)*cross(gradV1,gradV2)-A(2,1)*cross(gradV1,gradU2); %a1*w3-a3*w1
	v=cross(p,q);

	n=v/norm(v);
	
	*/


    Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
    
    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);
    
    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);
    
    
    Point3f crossV1U2=cross(gradV1,gradU2);
    Point3f crossV2U1=cross(gradV2,gradU1);
    Point3f crossU2U1=cross(gradU2,gradU1);
    Point3f crossV1V2=cross(gradV1,gradV2);
    

    
    
    Point3f p,q;
    
    p.x=A.at<float>(1,1)*crossU2U1.x-A.at<float>(0,1)*crossV2U1.x;
    p.y=A.at<float>(1,1)*crossU2U1.y-A.at<float>(0,1)*crossV2U1.y;
    p.z=A.at<float>(1,1)*crossU2U1.z-A.at<float>(0,1)*crossV2U1.z;
    
    q.x=A.at<float>(0,0)*crossV1V2.x-A.at<float>(1,0)*crossV1U2.x;
    q.y=A.at<float>(0,0)*crossV1V2.y-A.at<float>(1,0)*crossV1U2.y;
    q.z=A.at<float>(0,0)*crossV1V2.z-A.at<float>(1,0)*crossV1U2.z;
    
    
	Point3f n=cross(p,q);

    float length=sqrt(n.x*n.x+n.y*n.y+n.z*n.z);
    
	n.x/=length;
	n.y/=length;
	n.z/=length;

    return n;

}

Point3f FNESuper(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2){
    /*
     * 
	%V1.0:
	%pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);

%V2.0:
	F=ComputeFundamentalFromProjections(P1,P2)
	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2])
	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));


	gradU1=CalculateGradientsForU(P1,u1,pt3D(1),pt3D(2),pt3D(3));
	gradV1=CalculateGradientsForV(P1,v1,pt3D(1),pt3D(2),pt3D(3));

	gradU2=CalculateGradientsForU(P2,u2,pt3D(1),pt3D(2),pt3D(3));
	gradV2=CalculateGradientsForV(P2,v2,pt3D(1),pt3D(2),pt3D(3));


	p=A(2,2)*cross(gradV1,gradU2)-A(1,1)*cross(gradV2,gradU1);
	q=A(2,1)*cross(gradU2,gradU1)-A(1,2)*cross(gradV1,gradV2);

        p2=A(2,2)*cross(gradV1,gradV2)-A(2,1)*cross(gradV2,gradU1);
        q2=A(1,1)*cross(gradU2,gradU1)-A(1,2)*cross(gradV1,gradU2);

	p3=A(2,2)*cross(gradU2,gradU1)-A(1,2)*cross(gradV2,gradU1);
        q3=A(1,1)*cross(gradV1,gradV2)-A(2,1)*cross(gradV1,gradU2);

	MTX=[p';q';p2';q2';p3';q3'];

	[tmp1 tmp2 res]=svd(MTX);
	n=res(:,3);
	*/
    
    
        Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
    
    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);
    
    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);
    
    
    Point3f crossV1U2=cross(gradV1,gradU2);
    Point3f crossV2U1=cross(gradV2,gradU1);
    Point3f crossU2U1=cross(gradU2,gradU1);
    Point3f crossV1V2=cross(gradV1,gradV2);
    
    Point3f p1,q1;
    
    p1.x=A.at<float>(1,1)*crossV1U2.x-A.at<float>(0,0)*crossV2U1.x;
    p1.y=A.at<float>(1,1)*crossV1U2.y-A.at<float>(0,0)*crossV2U1.y;
    p1.z=A.at<float>(1,1)*crossV1U2.z-A.at<float>(0,0)*crossV2U1.z;
    
    q1.x=A.at<float>(1,0)*crossU2U1.x-A.at<float>(0,1)*crossV1V2.x;
    q1.y=A.at<float>(1,0)*crossU2U1.y-A.at<float>(0,1)*crossV1V2.y;
    q1.z=A.at<float>(1,0)*crossU2U1.z-A.at<float>(0,1)*crossV1V2.z;

    
    Point3f p2,q2;
    
    p2.x=A.at<float>(1,1)*crossV1V2.x-A.at<float>(1,0)*crossV2U1.x;
    p2.y=A.at<float>(1,1)*crossV1V2.y-A.at<float>(1,0)*crossV2U1.y;
    p2.z=A.at<float>(1,1)*crossV1V2.z-A.at<float>(1,0)*crossV2U1.z;
    
    q2.x=A.at<float>(0,0)*crossU2U1.x-A.at<float>(0,1)*crossV1U2.x;
    q2.y=A.at<float>(0,0)*crossU2U1.y-A.at<float>(0,1)*crossV1U2.y;
    q2.z=A.at<float>(0,0)*crossU2U1.z-A.at<float>(0,1)*crossV1U2.z;


    Point3f p3,q3;
    
    p3.x=A.at<float>(1,1)*crossU2U1.x-A.at<float>(0,1)*crossV2U1.x;
    p3.y=A.at<float>(1,1)*crossU2U1.y-A.at<float>(0,1)*crossV2U1.y;
    p3.z=A.at<float>(1,1)*crossU2U1.z-A.at<float>(0,1)*crossV2U1.z;
    
    q3.x=A.at<float>(0,0)*crossV1V2.x-A.at<float>(1,0)*crossV1U2.x;
    q3.y=A.at<float>(0,0)*crossV1V2.y-A.at<float>(1,0)*crossV1U2.y;
    q3.z=A.at<float>(0,0)*crossV1V2.z-A.at<float>(1,0)*crossV1U2.z;
    
    
    Mat mtx(6,3,CV_32F);
    
    mtx.at<float>(0,0)=p1.x;
    mtx.at<float>(0,1)=p1.y;
    mtx.at<float>(0,2)=p1.z;

    mtx.at<float>(1,0)=q1.x;
    mtx.at<float>(1,1)=q1.y;
    mtx.at<float>(1,2)=q1.z;

    mtx.at<float>(2,0)=p2.x;
    mtx.at<float>(2,1)=p2.y;
    mtx.at<float>(2,2)=p2.z;

    mtx.at<float>(3,0)=q2.x;
    mtx.at<float>(3,1)=q2.y;
    mtx.at<float>(3,2)=q2.z;

    mtx.at<float>(4,0)=p3.x;
    mtx.at<float>(4,1)=p3.y;
    mtx.at<float>(4,2)=p3.z;

    mtx.at<float>(5,0)=q3.x;
    mtx.at<float>(5,1)=q3.y;
    mtx.at<float>(5,2)=q3.z;
    
    
    Mat eVecs(9,9,CV_32F),eVals(9,9,CV_32F);
    eigen(mtx.t()*mtx, eVals, eVecs);

    Point3f n;
    n.x=eVecs.at<float>(2,0);    
    n.y=eVecs.at<float>(2,1);    
    n.z=eVecs.at<float>(2,2);    
    
    return n;
}





Point3f OPT(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2){


//	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
    Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
    
    





//	gradU1=CalculateGradientsForU(P1,u1,pt3D(1),pt3D(2),pt3D(3));
//	gradV1=CalculateGradientsForV(P1,v1,pt3D(1),pt3D(2),pt3D(3));

    
    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);

    
//	gradU2=CalculateGradientsForU(P2,u2,pt3D(1),pt3D(2),pt3D(3));
//	gradV2=CalculateGradientsForV(P2,v2,pt3D(1),pt3D(2),pt3D(3));

    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);


    
//	p1=cross(gradV1,gradU2);
//	p2=cross(gradU2,gradU1);
//	p3=cross(gradV1,gradV2);
//	p4=cross(gradV2,gradU1);
//	p5=cross(gradV1,gradU1);

    
    
    
    
    Point3f p1=cross(gradV1,gradU2);
    Point3f p2=cross(gradU2,gradU1);
    Point3f p3=cross(gradV1,gradV2);
    Point3f p4=cross(gradV2,gradU1);
    Point3f p5=cross(gradV1,gradU1);


    
//	a1=A(1,1);
//	a2=A(1,2);
//	a3=A(2,1);
//	a4=A(2,2);
    
    float a1=A.at<float>(0,0);
    float a2=A.at<float>(0,1);
    float a3=A.at<float>(1,0);
    float a4=A.at<float>(1,1);

//	AS=[a1,a2,a3,a4];
    
    Mat AS(1,4,CV_32F);
    AS.at<float>(0,0)=a1;
    AS.at<float>(0,1)=a2;
    AS.at<float>(0,2)=a3;
    AS.at<float>(0,3)=a4;

//	P=[p1';p2';p3';p4';p5'];  %!!!!!  ????
	
	
	
	Mat P(5,3,CV_32F);
    
    
    P.at<float>(0,0)=p1.x;
    P.at<float>(0,1)=p1.y;
    P.at<float>(0,2)=p1.z;
    
    P.at<float>(1,0)=p2.x;
    P.at<float>(1,1)=p2.y;
    P.at<float>(1,2)=p2.z;

    P.at<float>(2,0)=p3.x;
    P.at<float>(2,1)=p3.y;
    P.at<float>(2,2)=p3.z;

    P.at<float>(3,0)=p4.x;
    P.at<float>(3,1)=p4.y;
    P.at<float>(3,2)=p4.z;

    P.at<float>(4,0)=p5.x;
    P.at<float>(4,1)=p5.y;
    P.at<float>(4,2)=p5.z;
    
    
    

	Point3f nOpt=CoreOptimizator(P,AS,1.0);
    
    
    cout <<"nOpt:\n" << nOpt <<endl;
    
    return nOpt;
}





Point3f CalculateGradientsForU(Mat P,float u,float X,float Y,float Z){
   	float s=P.at<float>(2,0)*X+P.at<float>(2,1)*Y+P.at<float>(2,2)*Z+P.at<float>(2,3);
    Point3f gradU;

	gradU.x=(P.at<float>(0,0)-P.at<float>(2,0)*u)/s;
	gradU.y=(P.at<float>(0,1)-P.at<float>(2,1)*u)/s;
	gradU.z=(P.at<float>(0,2)-P.at<float>(2,2)*u)/s;


    return gradU;

}

Point3f CalculateGradientsForV(Mat P,float v,float X,float Y,float Z){

   	float s=P.at<float>(2,0)*X+P.at<float>(2,1)*Y+P.at<float>(2,2)*Z+P.at<float>(2,3);
    Point3f gradV;

	gradV.x=(P.at<float>(1,0)-P.at<float>(2,0)*v)/s;
	gradV.y=(P.at<float>(1,1)-P.at<float>(2,1)*v)/s;
	gradV.z=(P.at<float>(1,2)-P.at<float>(2,2)*v)/s;
    
    return gradV;
}

Point3f CoreOptimizator(Mat P, Mat AS, float alpha){

/*function [nOpt]=CoreOptimizator(P,AS,alpha)

		Q=[];
		for i=1:5
			Q(i,1)=P(i,1)-P(i,3);
			Q(i,2)=P(i,2)-P(i,3);
			Q(i,3)=P(i,3);
		end
		
*/
    Mat Q(5,3,CV_32F);
    for (int idx=0;idx<5;idx++){
        Q.at<float>(idx,0)=P.at<float>(idx,0)-P.at<float>(idx,2);
        Q.at<float>(idx,1)=P.at<float>(idx,1)-P.at<float>(idx,2);
        Q.at<float>(idx,2)=P.at<float>(idx,2);
    }
    

/*
		p1=P(1,:)';
		p2=P(2,:)';
		p3=P(3,:)';
		p4=P(4,:)';
		p5=P(5,:)';
*/
    Point3f p1;
    p1.x=P.at<float>(0,0);
    p1.y=P.at<float>(0,1);
    p1.z=P.at<float>(0,2);

    Point3f p2;
    p2.x=P.at<float>(1,0);
    p2.y=P.at<float>(1,1);
    p2.z=P.at<float>(1,2);
    
    Point3f p3;
    p3.x=P.at<float>(2,0);
    p3.y=P.at<float>(2,1);
    p3.z=P.at<float>(2,2);
    
    Point3f p4;
    p4.x=P.at<float>(3,0);
    p4.y=P.at<float>(3,1);
    p4.z=P.at<float>(3,2);
    
    Point3f p5;
    p5.x=P.at<float>(4,0);
    p5.y=P.at<float>(4,1);
    p5.z=P.at<float>(4,2);
    

    
    
/*
		a1=AS(1);
		a2=AS(2);
		a3=AS(3);
		a4=AS(4);
*/

    float a1=AS.at<float>(0,0);
    float a2=AS.at<float>(0,1);
    float a3=AS.at<float>(0,2);
    float a4=AS.at<float>(0,3);



/*
	
		B1=0.0;
		C1=0.0;
		D1=0.0;
		E1=0.0;
		F1=0.0;
		A2=0.0;
		C2=0.0;
		D2=0.0;
		E2=0.0;
		F2=0.0;

*/        

		float B1=0.0;
		float C1=0.0;
		float D1=0.0;
		float E1=0.0;
		float F1=0.0;
		float A2=0.0;
		float C2=0.0;
		float D2=0.0;
		float E2=0.0;
		float F2=0.0;

        
        for (int i=0;i<4;i++){

/*
        
		for i=1:4
			aa=Q(i,1)-alpha*Q(5,1)*AS(i);
			bb=Q(i,2)-alpha*Q(5,2)*AS(i);
			cc=Q(i,3)-alpha*Q(5,3)*AS(i);
        
*/
			float aa=Q.at<float>(i,0)-alpha*Q.at<float>(4,0)*AS.at<float>(0,i);
			float bb=Q.at<float>(i,1)-alpha*Q.at<float>(4,1)*AS.at<float>(0,i);
			float cc=Q.at<float>(i,2)-alpha*Q.at<float>(4,2)*AS.at<float>(0,i);

        

/*

			aa1=0;
			bb1=Q(5,2)*Q(i,1)-Q(i,2)*Q(5,1);
			cc1=Q(5,3)*Q(i,1)-Q(i,3)*Q(5,1);

			aa2=Q(5,1)*Q(i,2)-Q(i,1)*Q(5,2);
			bb2=0;
			cc2=Q(5,3)*Q(i,2)-Q(i,3)*Q(5,2);intersections
			
			
    */


			float aa1=0;
			float bb1=Q.at<float>(4,1)*Q.at<float>(i,0)-Q.at<float>(i,1)*Q.at<float>(4,0);
			float cc1=Q.at<float>(4,2)*Q.at<float>(i,0)-Q.at<float>(i,2)*Q.at<float>(4,0);

			float aa2=Q.at<float>(4,0)*Q.at<float>(i,1)-Q.at<float>(i,0)*Q.at<float>(4,1);
			float bb2=0.0f;
			float cc2=Q.at<float>(4,2)*Q.at<float>(i,1)-Q.at<float>(i,2)*Q.at<float>(4,1);



/*

			A2+=(aa*aa2);


			B1+=(bb*bb1);

			C1+=(aa*bb1+bb*aa1);
			C2+=(aa*bb2+bb*aa2);

			D1+=(aa*cc1+cc*aa1);
			D2+=(aa*cc2+cc*aa2);

			E1+=(bb*cc1+cc*bb1);
			E2+=(bb*cc2+cc*bb2);

			F1+=(cc*cc1);
			F2+=(cc*cc2);
			
spec_kvadratikus
		end
*/


			A2+=(aa*aa2);


			B1+=(bb*bb1);

			C1+=(aa*bb1+bb*aa1);
			C2+=(aa*bb2+bb*aa2);

			D1+=(aa*cc1+cc*aa1);
			D2+=(aa*cc2+cc*aa2);

			E1+=(bb*cc1+cc*bb1);
			E2+=(bb*cc2+cc*bb2);

			F1+=(cc*cc1);
			F2+=(cc*cc2);


        }


//		intersections=spec_kvadratikus(B1,C1,D1,E1,F1,A2,C2,D2,E2,F2);
		
        vector<Point2f> intersections=spec_kvadratikus(B1,C1,D1,E1,F1,A2,C2,D2,E2,F2);

        
/*		
		
//		bestErr=inf;
//		nOpt=[1,0,0]';
		
*/


		float bestErr=99999999999999.9f;
		Point3f nOpt(1.0f,0.0f,0.0f);

//		for i=1:rows(intersections)
        for (int idx=0;idx<intersections.size();idx++){
//			x=intersections(i,1);
//			y=intersections(i,2);
            Point2f pt=intersections.at(idx);
            float x=pt.x;
            float y=pt.y;
            
            
//			nEstCand=[x;y;1-x-y];
//			nEstCand=nEstCand/norm(nEstCand);

            float length=sqrtf(x*x+y*y+(1.0f-x-y)*(1.0f-x-y));
			Point3f nEstCand(x/length,y/length,(1.0f-x-y)/length);
            
//			if (getOptError(nEstCand,alpha,p1,p2,p3,p4,p5,a1,a2,a3,a4)<bestErr)
//				bestErr=getOptError(nEstCand,alpha,p1,p2,p3,p4,p5,a1,a2,a3,a4);
//				nOpt=nEstCand;
//			end
            

			if (getOptError(nEstCand,alpha,p1,p2,p3,p4,p5,a1,a2,a3,a4)<bestErr){
				float bestErr=getOptError(nEstCand,alpha,p1,p2,p3,p4,p5,a1,a2,a3,a4);
				nOpt=nEstCand;
            }
            
            
        }
//		end
//end
    return nOpt;
}//end coreOptimizatior


vector<Point2f> spec_kvadratikus(float B1,float C1,float D1,float E1,float F1,float A2,float C2,float D2,float E2,float F2){
            
//	threshold=max(abs([B1,C1,D1,E1,F1,A2,C2,D2,E2,F2]))/1e5;
    
    
    float threshold=B1;
    if(threshold<C1) threshold=C1;
    if(threshold<D1) threshold=D1;
    if(threshold<E1) threshold=E1;
    if(threshold<F1) threshold=F1;
    
    if(threshold<A2) threshold=A2;
    if(threshold<C2) threshold=C2;
    if(threshold<D2) threshold=D2;
    if(threshold<E2) threshold=E2;
    if(threshold<F2) threshold=F2;


//	x4=B1*A2*A2-C1*A2*C2;
//	x3=2*B1*A2*D2-C1*A2*E2-C1*D2*C2+D1*C2*C2-E1*A2*C2;
//	x2=B1*D2*D2+2*B1*A2*F2-C1*D2*E2-C1*F2*C2+2*D1*C2*E2-E1*A2*E2-E1*D2*C2+F1*C2*C2;
//	x1=2*B1*D2*F2-C1*F2*E2+D1*E2*E2-E1*D2*E2-E1*F2*C2+2*F1*C2*E2;
//	x0=B1*F2*F2-E1*F2*E2+F1*E2*E2;
    
	float x4=B1*A2*A2-C1*A2*C2;
	float x3=2*B1*A2*D2-C1*A2*E2-C1*D2*C2+D1*C2*C2-E1*A2*C2;
	float x2=B1*D2*D2+2*B1*A2*F2-C1*D2*E2-C1*F2*C2+2*D1*C2*E2-E1*A2*E2-E1*D2*C2+F1*C2*C2;
	float x1=2*B1*D2*F2-C1*F2*E2+D1*E2*E2-E1*D2*E2-E1*F2*C2+2*F1*C2*E2;
	float x0=B1*F2*F2-E1*F2*E2+F1*E2*E2;


//	intersections=[];
//	rs=roots([x4,x3,x2,x1,x0]);
//TODO: during debug
    
    
    
    
    vector<Point2f> intersections;
    
    Eigen::PolynomialSolver<float, Eigen::Dynamic> solver;
    Eigen::PolynomialSolver<float, Eigen::Dynamic>::RootsType r;
    
    if (abs(x4/x3)<1e-6){
    
        Eigen::VectorXf coeffsss(4);
        coeffsss << x0, x1, x2,x3;
        
        solver.compute(coeffsss);
        r = solver.roots();
    }
    else{
        Eigen::VectorXf coeffsss(5);
        coeffsss << x0, x1, x2,x3,x4;
        
        solver.compute(coeffsss);
        r = solver.roots();
    }
    
    
    
    
//	for i=1:size(rs)
    for(int i=0;i<r.size();i++){
        complex<float> rt=r[i];
//	if (isreal(rs(i)))
        if (rt.imag()==0.0f){
//		x=rs(i);
//		y=-(A2*x*x+D2*x+F2)/(C2*x+E2);
		float x=rt.real();
		float y=-(A2*x*x+D2*x+F2)/(C2*x+E2);
        
			
//		check1=B1*y*y+C1*x*y+D1*x+E1*y+F1;
//		check2=A2*x*x+C2*x*y+D2*x+E2*y+F2;
        
		float check1=B1*y*y+C1*x*y+D1*x+E1*y+F1;
		float check2=A2*x*x+C2*x*y+D2*x+E2*y+F2;
        
//		if ((abs(check1)<threshold)&&(abs(check2)<threshold))
		if ((abs(check1)<threshold)&&(abs(check2)<threshold)){
//			intersections(rows(intersections)+1,:)=[x,y];
			intersections.push_back(Point2f(x,y));
        
//			endif
        }
//		endif
        }
//	endfor
    }

    return intersections;
            
}


//function optError=getOptError(n,alpha,p1,p2,p3,p4,p5,a1,a2,a3,a4)
float getOptError(Point3f n,float alpha,Point3f p1,Point3f p2,Point3f p3,Point3f p4,Point3f p5,float a1,float a2,float a3,float a4){

    float np1=n.x*p1.x+n.y*p1.y+n.z*p1.z;
    float np2=n.x*p2.x+n.y*p2.y+n.z*p2.z;
    float np3=n.x*p3.x+n.y*p3.y+n.z*p3.z;
    float np4=n.x*p4.x+n.y*p4.y+n.z*p4.z;
    float np5=n.x*p5.x+n.y*p5.y+n.z*p5.z;
    
//	e1=(n'*p1)/(alpha*(n'*p5))-a1;
//	e2=(n'*p2)/(alpha*(n'*p5))-a2;
//	e3=(n'*p3)/(alpha*(n'*p5))-a3;
//	e4=(n'*p4)/(alpha*(n'*p5))-a4;
    
    float e1=np1/(alpha*np5)-a1;
    float e2=np2/(alpha*np5)-a2;
    float e3=np3/(alpha*np5)-a3;
    float e4=np4/(alpha*np5)-a4;


//	optError=e1*e1+e2*e2+e3*e3+e4*e4;
	float optError=e1*e1+e2*e2+e3*e3+e4*e4;
    return optError;
    
//end
}


Point3f RapidOPT(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2){
    Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
    
    Point3f gradU1=CalculateGradientsForU(P1,u1,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV1=CalculateGradientsForV(P1,v1,pt3D.x,pt3D.y,pt3D.z);
    
    Point3f gradU2=CalculateGradientsForU(P2,u2,pt3D.x,pt3D.y,pt3D.z);
	Point3f gradV2=CalculateGradientsForV(P2,v2,pt3D.x,pt3D.y,pt3D.z);
    
    
    
    Point3f p1=cross(gradV1,gradU2);
    Point3f p2=cross(gradU2,gradU1);
    Point3f p3=cross(gradV1,gradV2);
    Point3f p4=cross(gradV2,gradU1);
    Point3f p5=cross(gradV1,gradU1);
    
    float a11=A.at<float>(0,0);
    float a12=A.at<float>(0,1);
    float a21=A.at<float>(1,0);
    float a22=A.at<float>(1,1);
    
    float w11=p1.x;
    float w12=p1.y;
    float w13=p1.z;

    float w21=p2.x;
    float w22=p2.y;
    float w23=p2.z;

    float w31=p3.x;
    float w32=p3.y;
    float w33=p3.z;

    float w41=p4.x;
    float w42=p4.y;
    float w43=p4.z;

    float w51=p5.x;
    float w52=p5.y;
    float w53=p5.z;

    
    
  float n2=(-(w13*w13*w21*w22*w51) + w12*w13*w21*w23*w51 + w11*w13*w22*w23*w51 - w11*w12*w23*w23*w51 - 
  w13*w13*w31*w32*w51 - w23*w23*w31*w32*w51 + w12*w13*w31*w33*w51 + w22*w23*w31*w33*w51 + 
  w11*w13*w32*w33*w51 + w21*w23*w32*w33*w51 - w11*w12*w33*w33*w51 - w21*w22*w33*w33*w51 - 
  w13*w13*w41*w42*w51 - w23*w23*w41*w42*w51 - w33*w33*w41*w42*w51 + w12*w13*w41*w43*w51 + 
  w22*w23*w41*w43*w51 + w32*w33*w41*w43*w51 + w11*w13*w42*w43*w51 + 
  w21*w23*w42*w43*w51 + w31*w33*w42*w43*w51 - w11*w12*w43*w43*w51 - w21*w22*w43*w43*w51 - 
  w31*w32*w43*w43*w51 + a12*w13*w13*w22*w51*w51 - a12*w12*w13*w23*w51*w51 - 
  a11*w13*w22*w23*w51*w51 + a11*w12*w23*w23*w51*w51 + a21*w13*w13*w32*w51*w51 + 
  a21*w23*w23*w32*w51*w51 - a21*w12*w13*w33*w51*w51 - a21*w22*w23*w33*w51*w51 - 
  a11*w13*w32*w33*w51*w51 - a12*w23*w32*w33*w51*w51 + a11*w12*w33*w33*w51*w51 + 
  a12*w22*w33*w33*w51*w51 + a22*w13*w13*w42*w51*w51 + a22*w23*w23*w42*w51*w51 + 
  a22*w33*w33*w42*w51*w51 - a22*w12*w13*w43*w51*w51 - a22*w22*w23*w43*w51*w51 - 
  a22*w32*w33*w43*w51*w51 - a11*w13*w42*w43*w51*w51 - a12*w23*w42*w43*w51*w51 - 
  a21*w33*w42*w43*w51*w51 + a11*w12*w43*w43*w51*w51 + a12*w22*w43*w43*w51*w51 + 
  a21*w32*w43*w43*w51*w51 + w13*w13*w21*w21*w52 - 2*w11*w13*w21*w23*w52 + w11*w11*w23*w23*w52 + 
  w13*w13*w31*w31*w52 + w23*w23*w31*w31*w52 - 2*w11*w13*w31*w33*w52 - 2*w21*w23*w31*w33*w52 + 
  w11*w11*w33*w33*w52 + w21*w21*w33*w33*w52 + w13*w13*w41*w41*w52 + w23*w23*w41*w41*w52 + 
  w33*w33*w41*w41*w52 - 2*w11*w13*w41*w43*w52 - 2*w21*w23*w41*w43*w52 -
  2*w31*w33*w41*w43*w52 + w11*w11*w43*w43*w52 + w21*w21*w43*w43*w52 + w31*w31*w43*w43*w52 -
  a12*w13*w13*w21*w51*w52 + a12*w11*w13*w23*w51*w52 + a11*w13*w21*w23*w51*w52 -
  a11*w11*w23*w23*w51*w52 - a21*w13*w13*w31*w51*w52 - a21*w23*w23*w31*w51*w52 +
  a21*w11*w13*w33*w51*w52 + a21*w21*w23*w33*w51*w52 + a11*w13*w31*w33*w51*w52 +
  a12*w23*w31*w33*w51*w52 - a11*w11*w33*w33*w51*w52 - a12*w21*w33*w33*w51*w52 -
  a22*w13*w13*w41*w51*w52 - a22*w23*w23*w41*w51*w52 - a22*w33*w33*w41*w51*w52 +
  a22*w11*w13*w43*w51*w52 + a22*w21*w23*w43*w51*w52 + a22*w31*w33*w43*w51*w52 +
  a11*w13*w41*w43*w51*w52 + a12*w23*w41*w43*w51*w52 + a21*w33*w41*w43*w51*w52 -
  a11*w11*w43*w43*w51*w52 - a12*w21*w43*w43*w51*w52 - a21*w31*w43*w43*w51*w52 -
  w12*w13*w21*w21*w53 + w11*w13*w21*w22*w53 + w11*w12*w21*w23*w53 - w11*w11*w22*w23*w53 -
  w12*w13*w31*w31*w53 - w22*w23*w31*w31*w53 + w11*w13*w31*w32*w53 + w21*w23*w31*w32*w53 +
  w11*w12*w31*w33*w53 + w21*w22*w31*w33*w53 - w11*w11*w32*w33*w53 - w21*w21*w32*w33*w53 -
  w12*w13*w41*w41*w53 - w22*w23*w41*w41*w53 - w32*w33*w41*w41*w53 + w11*w13*w41*w42*w53 +
  w21*w23*w41*w42*w53 + w31*w33*w41*w42*w53 + w11*w12*w41*w43*w53 +
  w21*w22*w41*w43*w53 + w31*w32*w41*w43*w53 - w11*w11*w42*w43*w53 - w21*w21*w42*w43*w53 -
  w31*w31*w42*w43*w53 + a12*w12*w13*w21*w51*w53 - 2*a12*w11*w13*w22*w51*w53 +
  a11*w13*w21*w22*w51*w53 + a12*w11*w12*w23*w51*w53 - 2*a11*w12*w21*w23*w51*w53 +
  a11*w11*w22*w23*w51*w53 + a21*w12*w13*w31*w51*w53 + a21*w22*w23*w31*w51*w53 -
  2*a21*w11*w13*w32*w51*w53 - 2*a21*w21*w23*w32*w51*w53 + a11*w13*w31*w32*w51*w53 +
  a12*w23*w31*w32*w51*w53 + a21*w11*w12*w33*w51*w53 + a21*w21*w22*w33*w51*w53 -
  2*a11*w12*w31*w33*w51*w53 - 2*a12*w22*w31*w33*w51*w53 + a11*w11*w32*w33*w51*w53 +
  a12*w21*w32*w33*w51*w53 + a22*w12*w13*w41*w51*w53 + a22*w22*w23*w41*w51*w53 +
  a22*w32*w33*w41*w51*w53 - 2*a22*w11*w13*w42*w51*w53 - 2*a22*w21*w23*w42*w51*w53 -
  2*a22*w31*w33*w42*w51*w53 + a11*w13*w41*w42*w51*w53 + a12*w23*w41*w42*w51*w53 +
  a21*w33*w41*w42*w51*w53 + a22*w11*w12*w43*w51*w53 + a22*w21*w22*w43*w51*w53 +
  a22*w31*w32*w43*w51*w53 - 2*a11*w12*w41*w43*w51*w53 - 2*a12*w22*w41*w43*w51*w53 -
  2*a21*w32*w41*w43*w51*w53 + a11*w11*w42*w43*w51*w53 + a12*w21*w42*w43*w51*w53 +
  a21*w31*w42*w43*w51*w53 + a12*w11*w13*w21*w52*w53 - a11*w13*w21*w21*w52*w53 -
  a12*w11*w11*w23*w52*w53 + a11*w11*w21*w23*w52*w53 + a21*w11*w13*w31*w52*w53 +
  a21*w21*w23*w31*w52*w53 - a11*w13*w31*w31*w52*w53 - a12*w23*w31*w31*w52*w53 -
  a21*w11*w11*w33*w52*w53 - a21*w21*w21*w33*w52*w53 + a11*w11*w31*w33*w52*w53 +
  a12*w21*w31*w33*w52*w53 + a22*w11*w13*w41*w52*w53 + a22*w21*w23*w41*w52*w53 +
  a22*w31*w33*w41*w52*w53 - a11*w13*w41*w41*w52*w53 - a12*w23*w41*w41*w52*w53 -
  a21*w33*w41*w41*w52*w53 - a22*w11*w11*w43*w52*w53 - a22*w21*w21*w43*w52*w53 -
  a22*w31*w31*w43*w52*w53 + a11*w11*w41*w43*w52*w53 + a12*w21*w41*w43*w52*w53 +
  a21*w31*w41*w43*w52*w53 - a12*w11*w12*w21*w53*w53 + a11*w12*w21*w21*w53*w53 +
  a12*w11*w11*w22*w53*w53 - a11*w11*w21*w22*w53*w53 - a21*w11*w12*w31*w53*w53 -
  a21*w21*w22*w31*w53*w53 + a11*w12*w31*w31*w53*w53 + a12*w22*w31*w31*w53*w53 +
  a21*w11*w11*w32*w53*w53 + a21*w21*w21*w32*w53*w53 - a11*w11*w31*w32*w53*w53 -
  a12*w21*w31*w32*w53*w53 - a22*w11*w12*w41*w53*w53 - a22*w21*w22*w41*w53*w53 -
  a22*w31*w32*w41*w53*w53 + a11*w12*w41*w41*w53*w53 + a12*w22*w41*w41*w53*w53 +
  a21*w32*w41*w41*w53*w53 + a22*w11*w11*w42*w53*w53 + a22*w21*w21*w42*w53*w53 +
  a22*w31*w31*w42*w53*w53 - a11*w11*w41*w42*w53*w53 - a12*w21*w41*w42*w53*w53 -
  a21*w31*w41*w42*w53*w53)/(w12*w13*w21*w22*w51 - w11*w13*w22*w22*w51 - w12*w12*w21*w23*w51 +
  w11*w12*w22*w23*w51 + w12*w13*w31*w32*w51 + w22*w23*w31*w32*w51 - w11*w13*w32*w32*w51 -
  w21*w23*w32*w32*w51 - w12*w12*w31*w33*w51 - w22*w22*w31*w33*w51 + w11*w12*w32*w33*w51 +
  w21*w22*w32*w33*w51 + w12*w13*w41*w42*w51 + w22*w23*w41*w42*w51 +
  w32*w33*w41*w42*w51 - w11*w13*w42*w42*w51 - w21*w23*w42*w42*w51 - w31*w33*w42*w42*w51 -
  w12*w12*w41*w43*w51 - w22*w22*w41*w43*w51 - w32*w32*w41*w43*w51 + w11*w12*w42*w43*w51 +
  w21*w22*w42*w43*w51 + w31*w32*w42*w43*w51 - a12*w12*w13*w22*w51*w51 +
  a11*w13*w22*w22*w51*w51 + a12*w12*w12*w23*w51*w51 - a11*w12*w22*w23*w51*w51 -
  a21*w12*w13*w32*w51*w51 - a21*w22*w23*w32*w51*w51 + a11*w13*w32*w32*w51*w51 +
  a12*w23*w32*w32*w51*w51 + a21*w12*w12*w33*w51*w51 + a21*w22*w22*w33*w51*w51 -
  a11*w12*w32*w33*w51*w51 - a12*w22*w32*w33*w51*w51 - a22*w12*w13*w42*w51*w51 -
  a22*w22*w23*w42*w51*w51 - a22*w32*w33*w42*w51*w51 + a11*w13*w42*w42*w51*w51 +
  a12*w23*w42*w42*w51*w51 + a21*w33*w42*w42*w51*w51 + a22*w12*w12*w43*w51*w51 +
  a22*w22*w22*w43*w51*w51 + a22*w32*w32*w43*w51*w51 - a11*w12*w42*w43*w51*w51 -
  a12*w22*w42*w43*w51*w51 - a21*w32*w42*w43*w51*w51 - w12*w13*w21*w21*w52 +
  w11*w13*w21*w22*w52 + w11*w12*w21*w23*w52 - w11*w11*w22*w23*w52 - w12*w13*w31*w31*w52 -
  w22*w23*w31*w31*w52 + w11*w13*w31*w32*w52 + w21*w23*w31*w32*w52 + w11*w12*w31*w33*w52 +
  w21*w22*w31*w33*w52 - w11*w11*w32*w33*w52 - w21*w21*w32*w33*w52 - w12*w13*w41*w41*w52 -
  w22*w23*w41*w41*w52 - w32*w33*w41*w41*w52 + w11*w13*w41*w42*w52 + w21*w23*w41*w42*w52 +
  w31*w33*w41*w42*w52 + w11*w12*w41*w43*w52 + w21*w22*w41*w43*w52 +
  w31*w32*w41*w43*w52 - w11*w11*w42*w43*w52 - w21*w21*w42*w43*w52 - w31*w31*w42*w43*w52 +
  a12*w12*w13*w21*w51*w52 + a12*w11*w13*w22*w51*w52 - 2*a11*w13*w21*w22*w51*w52 -
  2*a12*w11*w12*w23*w51*w52 + a11*w12*w21*w23*w51*w52 + a11*w11*w22*w23*w51*w52 +
  a21*w12*w13*w31*w51*w52 + a21*w22*w23*w31*w51*w52 + a21*w11*w13*w32*w51*w52 +
  a21*w21*w23*w32*w51*w52 - 2*a11*w13*w31*w32*w51*w52 - 2*a12*w23*w31*w32*w51*w52 -
  2*a21*w11*w12*w33*w51*w52 - 2*a21*w21*w22*w33*w51*w52 + a11*w12*w31*w33*w51*w52 +
  a12*w22*w31*w33*w51*w52 + a11*w11*w32*w33*w51*w52 + a12*w21*w32*w33*w51*w52 +
  a22*w12*w13*w41*w51*w52 + a22*w22*w23*w41*w51*w52 + a22*w32*w33*w41*w51*w52 +
  a22*w11*w13*w42*w51*w52 + a22*w21*w23*w42*w51*w52 + a22*w31*w33*w42*w51*w52 -
  2*a11*w13*w41*w42*w51*w52 - 2*a12*w23*w41*w42*w51*w52 - 2*a21*w33*w41*w42*w51*w52 -
  2*a22*w11*w12*w43*w51*w52 - 2*a22*w21*w22*w43*w51*w52 - 2*a22*w31*w32*w43*w51*w52 +
  a11*w12*w41*w43*w51*w52 + a12*w22*w41*w43*w51*w52 + a21*w32*w41*w43*w51*w52 +
  a11*w11*w42*w43*w51*w52 + a12*w21*w42*w43*w51*w52 + a21*w31*w42*w43*w51*w52 -
  a12*w11*w13*w21*w52*w52 + a11*w13*w21*w21*w52*w52 + a12*w11*w11*w23*w52*w52 -
  a11*w11*w21*w23*w52*w52 - a21*w11*w13*w31*w52*w52 - a21*w21*w23*w31*w52*w52 +
  a11*w13*w31*w31*w52*w52 + a12*w23*w31*w31*w52*w52 + a21*w11*w11*w33*w52*w52 +
  a21*w21*w21*w33*w52*w52 - a11*w11*w31*w33*w52*w52 - a12*w21*w31*w33*w52*w52 -
  a22*w11*w13*w41*w52*w52 - a22*w21*w23*w41*w52*w52 - a22*w31*w33*w41*w52*w52 +
  a11*w13*w41*w41*w52*w52 + a12*w23*w41*w41*w52*w52 + a21*w33*w41*w41*w52*w52 +
  a22*w11*w11*w43*w52*w52 + a22*w21*w21*w43*w52*w52 + a22*w31*w31*w43*w52*w52 -
  a11*w11*w41*w43*w52*w52 - a12*w21*w41*w43*w52*w52 - a21*w31*w41*w43*w52*w52 +
  w12*w12*w21*w21*w53 - 2*w11*w12*w21*w22*w53 + w11*w11*w22*w22*w53 + w12*w12*w31*w31*w53 +
  w22*w22*w31*w31*w53 - 2*w11*w12*w31*w32*w53 - 2*w21*w22*w31*w32*w53 + w11*w11*w32*w32*w53 +
  w21*w21*w32*w32*w53 + w12*w12*w41*w41*w53 + w22*w22*w41*w41*w53 + w32*w32*w41*w41*w53 -
  2*w11*w12*w41*w42*w53 - 2*w21*w22*w41*w42*w53 - 2*w31*w32*w41*w42*w53 +
  w11*w11*w42*w42*w53 + w21*w21*w42*w42*w53 + w31*w31*w42*w42*w53 - a12*w12*w12*w21*w51*w53 +
  a12*w11*w12*w22*w51*w53 + a11*w12*w21*w22*w51*w53 - a11*w11*w22*w22*w51*w53 -
  a21*w12*w12*w31*w51*w53 - a21*w22*w22*w31*w51*w53 + a21*w11*w12*w32*w51*w53 +
  a21*w21*w22*w32*w51*w53 + a11*w12*w31*w32*w51*w53 + a12*w22*w31*w32*w51*w53 -
  a11*w11*w32*w32*w51*w53 - a12*w21*w32*w32*w51*w53 - a22*w12*w12*w41*w51*w53 -
  a22*w22*w22*w41*w51*w53 - a22*w32*w32*w41*w51*w53 + a22*w11*w12*w42*w51*w53 +
  a22*w21*w22*w42*w51*w53 + a22*w31*w32*w42*w51*w53 + a11*w12*w41*w42*w51*w53 +
  a12*w22*w41*w42*w51*w53 + a21*w32*w41*w42*w51*w53 - a11*w11*w42*w42*w51*w53 -
  a12*w21*w42*w42*w51*w53 - a21*w31*w42*w42*w51*w53 + a12*w11*w12*w21*w52*w53 -
  a11*w12*w21*w21*w52*w53 - a12*w11*w11*w22*w52*w53 + a11*w11*w21*w22*w52*w53 +
  a21*w11*w12*w31*w52*w53 + a21*w21*w22*w31*w52*w53 - a11*w12*w31*w31*w52*w53 -
  a12*w22*w31*w31*w52*w53 - a21*w11*w11*w32*w52*w53 - a21*w21*w21*w32*w52*w53 +
  a11*w11*w31*w32*w52*w53 + a12*w21*w31*w32*w52*w53 + a22*w11*w12*w41*w52*w53 +
  a22*w21*w22*w41*w52*w53 + a22*w31*w32*w41*w52*w53 - a11*w12*w41*w41*w52*w53 -
  a12*w22*w41*w41*w52*w53 - a21*w32*w41*w41*w52*w53 - a22*w11*w11*w42*w52*w53 -
  a22*w21*w21*w42*w52*w53 - a22*w31*w31*w42*w52*w53 + a11*w11*w41*w42*w52*w53 +
  a12*w21*w41*w42*w52*w53 + a21*w31*w41*w42*w52*w53);
  
  
  
float n1=-((-(w13*w13*w51) - w23*w23*w51 - w33*w33*w51 - w43*w43*w51 +
   n2*n2*(-(w12*w12*w51) - w22*w22*w51 - w32*w32*w51 - w42*w42*w51 + w31*w32*w52 + w41*w42*w52 +
     a21*w32*w51*w52 + a22*w42*w51*w52 + w12*(w11 + a11*w51)*w52 +
     w22*(w21 + a12*w51)*w52 - a11*w11*w52*w52 - a12*w21*w52*w52 - a21*w31*w52*w52 -
     a22*w41*w52*w52) + w21*w23*w53 + w31*w33*w53 + w41*w43*w53 + a12*w23*w51*w53 +
   a21*w33*w51*w53 + a22*w43*w51*w53 + w13*(w11 + a11*w51)*w53 - a11*w11*w53*w53 -
   a12*w21*w53*w53 - a21*w31*w53*w53 - a22*w41*w53*w53 +
   n2*(-2*w12*w13*w51 - 2*w22*w23*w51 - 2*w32*w33*w51 - 2*w42*w43*w51 + w11*w13*w52 +
     w21*w23*w52 + w31*w33*w52 + w41*w43*w52 + a11*w13*w51*w52 + a12*w23*w51*w52 +
     a21*w33*w51*w52 + a22*w43*w51*w52 + w31*w32*w53 + w41*w42*w53 + a21*w32*w51*w53 +
     a22*w42*w51*w53 + w12*(w11 + a11*w51)*w53 + w22*(w21 + a12*w51)*w53 -
     2*a11*w11*w52*w53 - 2*a12*w21*w52*w53 - 2*a21*w31*w52*w53 - 2*a22*w41*w52*w53))/
  (-(w21*w23*w51) - w31*w33*w51 - w41*w43*w51 + a11*w13*w51*w51 + a12*w23*w51*w51 +
   a21*w33*w51*w51 + a22*w43*w51*w51 + n2*(-(w31*w32*w51) - w41*w42*w51 + a11*w12*w51*w51 +
     a12*w22*w51*w51 + a21*w32*w51*w51 + a22*w42*w51*w51 + w11*w11*w52 + w21*w21*w52 + w31*w31*w52 +
     w41*w41*w52 - a21*w31*w51*w52 - a22*w41*w51*w52 - w11*w51*(w12 + a11*w52) -
     w21*w51*(w22 + a12*w52)) + w11*w11*w53 + w21*w21*w53 + w31*w31*w53 + w41*w41*w53 -
   a12*w21*w51*w53 - a21*w31*w51*w53 - a22*w41*w51*w53 - w11*w51*(w13 + a11*w53)));
    

	Point3f nOpt;
    float length=sqrtf(n1*n1+n2*n2+1);
    nOpt.x=n1/length;
    nOpt.y=n2/length;
    nOpt.z=1.0/length;

    return nOpt;
}
