#include "PolyUtility.h"

void PolyPrint(vector<float> poly){
        int degree=poly.size()-1;
        for (int idx=degree;idx>=0;idx--){
            if (idx>0)
                cout << poly.at(idx) <<"*x^"<< idx <<" + ";
            else
                cout << poly.at(0) ;
        
        }
        
        cout <<endl;
        
        
    }//end PolyPrint


//Test,test,test!!
    vector<float> PolyConv(vector<float> poly1,vector<float> poly2){
        vector<float> ret;
        
        int degree1=poly1.size()-1;
        int degree2=poly2.size()-1;
        int degree=degree1+degree2;
        
        float *res=new float[degree1+degree2+1];
        for (int idx=0;idx<=degree;idx++) res[idx]=0.0f;
        
        for (int idx1=0;idx1<=degree1;idx1++) for (int idx2=0;idx2<=degree2;idx2++){
            res[idx1+idx2]+=poly1.at(idx1)*poly2.at(idx2);
        }//end for-for
        
        for (int idx=0;idx<=(degree1+degree2);idx++)
            ret.push_back(res[idx]);
        
        delete[] res;
        return ret;        
    }//end function PolyConv


    vector<float> PolyGeneralAdd(vector<float> poly1,vector<float> poly2,bool isSubstract){
        vector<float> ret;
        int degree1=poly1.size()-1;
        int degree2=poly2.size()-1;
        
        int degree;
        if (degree1>degree2)
            degree=degree1;
        else
            degree=degree2;
        

        float *res=new float[degree+1];
        for(int idx=0;idx<=degree;idx++) res[idx]=0.0f;
        
        for(int idx=0;idx<=degree1;idx++) res[idx]+=poly1.at(idx);
        if (isSubstract)
            for(int idx=0;idx<=degree2;idx++) res[idx]-=poly2.at(idx);
        else
            for(int idx=0;idx<=degree2;idx++) res[idx]+=poly2.at(idx);
        
        for (int idx=0;idx<=degree;idx++)
            ret.push_back(res[idx]);
        
        delete[] res;
        return ret;

    }
    
    
    vector<float> PolyAdd(vector<float> poly1,vector<float> poly2){
        return PolyGeneralAdd(poly1,poly2,false);
    }//end function PolyAdd

    vector<float> PolySub(vector<float> poly1,vector<float> poly2){
        return PolyGeneralAdd(poly1,poly2,true);
    }//end function PolySub
#include "PolyUtility.h"
    

    vector<float> PolyMul(vector<float> poly,float scalar){
        vector<float> ret;
        int degree=poly.size()-1;
        
        for (int idx=0;idx<=degree;idx++)
            ret.push_back(scalar*poly.at(idx));
        
        return ret;

    }//end function PolyMul
    
    
    vector<float> PolyShift(vector<float> poly,int shift){
        vector<float> ret;
        int degree=poly.size()-1;
        

            
        for (int idx=0;idx<=degree;idx++)
            ret.push_back(poly.at(idx));
        
        for (int idx=0;idx<shift;idx++)
            ret.push_back(0.0f);

        return ret;
    }

    vector<float> PolyAddZeroElements(vector<float> poly,int shift){
        vector<float> ret;
        int degree=poly.size()-1;
        

        for (int idx=0;idx<shift;idx++)
            ret.push_back(0.0f);
            
        for (int idx=0;idx<=degree;idx++)
            ret.push_back(poly.at(idx));
        return ret;
    }
    
    
    vector<pair<float,float>> PolyRoots(vector<float> poly){

        
        vector<pair<float,float>> ret;
        int degree=poly.size()-1;
        
//        cout <<"Poly:";
//        for (int id=0;id<=degree;id++) cout << poly.at(id) <<",";
//        cout <<endl;

        
        MatrixXf mtx(degree,degree);
        for (int r=0;r<degree;r++) for (int c=0;c<degree;c++)  mtx(r,c) = 0.0f;
        for (int r=1;r<degree;r++) mtx(r-1,r) = 1.0f;
        for (int r=0;r<degree;r++) mtx(degree-1,r) = -1.0f*poly.at(r)/poly.at(degree);

/* For debug:        
        for(int id1=0;id1<degree;id1++){
            cout<< "[";
            for(int id2=0;id2<degree;id2++) cout << mtx(id1,id2) <<",";
            cout<< "\n";
        }
            cout<< "]\n";
*/        
        EigenSolver<MatrixXf> es;
        
        es.compute(mtx);       
    
        VectorXcf vals=es.eigenvalues();
//        cout <<vals <<endl;
        for (int idx=0;idx<degree;idx++){
            pair<float,float> item(vals.real()(idx),vals.imag()(idx));
            ret.push_back(item);
        }
        return ret;
    }
