#include<opencv2/core.hpp>
#include<iostream>

#include "NormalEstimation.h"
#include "HajderTriangulation.h"

using namespace cv;
using namespace std;

int main(int argc, char** argv){


//A= [   0.73196   0.67570;    0.55518   0.27147]

Mat A(2,2,CV_32F);
A.at<float>(0,0)=0.73196;
A.at<float>(0,1)=0.67570;
A.at<float>(1,0)=0.55518;
A.at<float>(1,1)=0.27147;


cout <<A << endl;
 


// fu=215.5;
// fv=288.9;

// u0=400;
// v0=300;

float fu=215.5;
float fv=288.9;

float u0=400;
float v0=300;

// K= [fu,0,u0;0,fv,v0;0,0,1]


Mat K=Mat::zeros(3,3,CV_32F);
K.at<float>(0,0)=fu;
K.at<float>(1,1)=fv;
K.at<float>(0,2)=u0;
K.at<float>(1,2)=v0;
K.at<float>(2,2)=1.0f;


cout <<K << endl;



// u1=239.45
// v1=222.40

// u2=89.454
// v2=336.68


float u1=239.45;
float v1=222.40;

float u2=89.454;
float v2=336.68;




//P1=K*[eye(3),zeros(3,1)]

Mat P1=Mat::zeros(3,4,CV_32F);
P1.at<float>(0,0)=1.0f;
P1.at<float>(1,1)=1.0f;
P1.at<float>(2,2)=1.0f;

P1=K*P1;

cout <<P1 << endl;


// alpha=5.8914
// beta=0.1415
// gamma=6.1248

float alpha=5.8914;
float beta=0.1415;
float gamma=6.1248;


// Rx=[cos(alpha),-sin(alpha),0;sin(alpha),cos(alpha),0;0,0,1]

Mat Rx=Mat::zeros(3,3,CV_32F);
Rx.at<float>(0,0)=Rx.at<float>(1,1)=cosf(alpha);
Rx.at<float>(0,1)=-1.0f*sinf(alpha);
Rx.at<float>(1,0)=sinf(alpha);
Rx.at<float>(2,2)=1.0f;


cout <<Rx << endl;
 
// Ry=[cos(beta),0,sin(beta);0,1,0;-sin(beta),0,cos(beta)]
 


Mat Ry=Mat::zeros(3,3,CV_32F);
Ry.at<float>(0,0)=Ry.at<float>(2,2)=cosf(beta);
Ry.at<float>(2,0)=-1.0f*sinf(beta);
Ry.at<float>(0,2)=sinf(beta);
Ry.at<float>(1,1)=1.0f;


cout <<Ry << endl;

// Rz=[1,0,0;0,cos(gamma),-sin(gamma);0,sin(gamma),cos(gamma)]
Mat Rz=Mat::zeros(3,3,CV_32F);
Rz.at<float>(1,1)=Rz.at<float>(2,2)=cosf(gamma);
Rz.at<float>(1,2)=-1.0f*sinf(gamma);
Rz.at<float>(2,1)=sinf(gamma);
Rz.at<float>(0,0)=1.0f;

cout <<Rz << endl;



// R=Rz*Ry*Rz
Mat R=Rz*Ry*Rz;
cout <<R << endl;

//cout <<R.t()*R << endl;



// t = [   6.2090 ;    8.7086 ;    9.0632 ]
Mat t(3,1,CV_32F);
t.at<float>(0,0)=6.2090f;
t.at<float>(1,0)=8.7086f;
t.at<float>(2,0)=9.0632f;

cout <<t << endl;



// P2=K*[R,t]

Mat Rt(3,4,CV_32F);


Rt.at<float>(0,3)=t.at<float>(0,0);
Rt.at<float>(1,3)=t.at<float>(1,0);
Rt.at<float>(2,3)=t.at<float>(2,0);

for (int idx=0;idx<3;idx++) for (int idx2=0;idx2<3;idx2++) Rt.at<float>(idx,idx2)=R.at<float>(idx,idx2);

Mat P2=K*Rt;
cout <<P2 << endl;

//FNE1(A,P1,P2,u1,v1,u2,v2);

Point3f pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);

cout <<pt3D <<endl;

Point3f n1=FNE1(A,P1,P2,u1,v1,u2,v2);
Point3f n2=FNE2(A,P1,P2,u1,v1,u2,v2);
Point3f n3=FNE3(A,P1,P2,u1,v1,u2,v2);

Point3f nS=FNESuper(A,P1,P2,u1,v1,u2,v2);

Point3f nCO=CubicOpt(A,P1,P2,u1,v1,u2,v2);

Point3f nO=OPT(A,P1,P2,u1,v1,u2,v2);


cout << "FNE1:\n" <<n1 <<endl;
cout << "FNE2:\n" <<n2 <<endl;
cout << "FNE3:\n" <<n3 <<endl;

cout << "FNESuper:\n" <<nS <<endl;

cout << "CubicOPT:\n" <<nCO <<endl;

cout << "OPT:\n" <<nO <<endl;

}
