function [nEst,n1,n2]=RapidOpt(A,P1,P2,u1,v1,u2,v2,mode,ptsCorr,affCorr)

p1=[u1;v1];
p2=[u2;v2];

F=ComputeFundamentalFromProjections(P1,P2);


if (ptsCorr==1)
	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2]);
	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));
else
	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
end


if (affCorr==1)
    [A]=GetClosestConsistentAffineTransform(A, F, p1(1:2), p2(1:2));
end



gradU1=CalculateGradientsForU(P1,p1(1),pt3D(1),pt3D(2),pt3D(3));
gradV1=CalculateGradientsForV(P1,p1(2),pt3D(1),pt3D(2),pt3D(3));

gradU2=CalculateGradientsForU(P2,p2(1),pt3D(1),pt3D(2),pt3D(3));
gradV2=CalculateGradientsForV(P2,p2(2),pt3D(1),pt3D(2),pt3D(3));


p1=cross(gradV1,gradU2);
p2=cross(gradU2,gradU1);
p3=cross(gradV1,gradV2);
p4=cross(gradV2,gradU1);
p5=cross(gradV1,gradU1);

a1=A(1,1);
a2=A(1,2);
a3=A(2,1);
a4=A(2,2);


switch mode
    case 1
        w11=p1(1);
        w12=p1(2);
        w13=p1(3);

        w21=p2(1);
        w22=p2(2);
        w23=p2(3);

        w31=p3(1);
        w32=p3(2);
        w33=p3(3);

        w41=p4(1);
        w42=p4(2);
        w43=p4(3);

        w51=p5(1);
        w52=p5(2);
        w53=p5(3);


    case 2
        w11=p1(1);
        w12=p1(3);
        w13=p1(2);

        w21=p2(1);
        w22=p2(3);
        w23=p2(2);

        w31=p3(1);
        w32=p3(3);
        w33=p3(2);

        w41=p4(1);
        w42=p4(3);
        w43=p4(2);

        w51=p5(1);
        w52=p5(3);
        w53=p5(2);


    case 3
        w11=p1(3);
        w12=p1(2);
        w13=p1(1);

        w21=p2(3);
        w22=p2(2);
        w23=p2(1);

        w31=p3(3);
        w32=p3(2);
        w33=p3(1);

        w41=p4(3);
        w42=p4(2);
        w43=p4(1);

        w51=p5(3);
        w52=p5(2);
        w53=p5(1);

end


a11=A(1,1);
a12=A(1,2);
a21=A(2,1);
a22=A(2,2);


n2=(-(w13^2*w21*w22*w51) + w12*w13*w21*w23*w51 + w11*w13*w22*w23*w51 - w11*w12*w23^2*w51 -   w13^2*w31*w32*w51 - w23^2*w31*w32*w51 + w12*w13*w31*w33*w51 + w22*w23*w31*w33*w51 +   w11*w13*w32*w33*w51 + w21*w23*w32*w33*w51 - w11*w12*w33^2*w51 - w21*w22*w33^2*w51 -   w13^2*w41*w42*w51 - w23^2*w41*w42*w51 - w33^2*w41*w42*w51 + w12*w13*w41*w43*w51 +   w22*w23*w41*w43*w51 + w32*w33*w41*w43*w51 + w11*w13*w42*w43*w51 +   w21*w23*w42*w43*w51 + w31*w33*w42*w43*w51 - w11*w12*w43^2*w51 - w21*w22*w43^2*w51 -   w31*w32*w43^2*w51 + a12*w13^2*w22*w51^2 - a12*w12*w13*w23*w51^2 -   a11*w13*w22*w23*w51^2 + a11*w12*w23^2*w51^2 + a21*w13^2*w32*w51^2 +   a21*w23^2*w32*w51^2 - a21*w12*w13*w33*w51^2 - a21*w22*w23*w33*w51^2 -   a11*w13*w32*w33*w51^2 - a12*w23*w32*w33*w51^2 + a11*w12*w33^2*w51^2 +   a12*w22*w33^2*w51^2 + a22*w13^2*w42*w51^2 + a22*w23^2*w42*w51^2 +   a22*w33^2*w42*w51^2 - a22*w12*w13*w43*w51^2 - a22*w22*w23*w43*w51^2 -   a22*w32*w33*w43*w51^2 - a11*w13*w42*w43*w51^2 - a12*w23*w42*w43*w51^2 -   a21*w33*w42*w43*w51^2 + a11*w12*w43^2*w51^2 + a12*w22*w43^2*w51^2 +   a21*w32*w43^2*w51^2 + w13^2*w21^2*w52 - 2*w11*w13*w21*w23*w52 + w11^2*w23^2*w52 +   w13^2*w31^2*w52 + w23^2*w31^2*w52 - 2*w11*w13*w31*w33*w52 - 2*w21*w23*w31*w33*w52 +   w11^2*w33^2*w52 + w21^2*w33^2*w52 + w13^2*w41^2*w52 + w23^2*w41^2*w52 +   w33^2*w41^2*w52 - 2*w11*w13*w41*w43*w52 - 2*w21*w23*w41*w43*w52 -   2*w31*w33*w41*w43*w52 + w11^2*w43^2*w52 + w21^2*w43^2*w52 + w31^2*w43^2*w52 -   a12*w13^2*w21*w51*w52 + a12*w11*w13*w23*w51*w52 + a11*w13*w21*w23*w51*w52 -   a11*w11*w23^2*w51*w52 - a21*w13^2*w31*w51*w52 - a21*w23^2*w31*w51*w52 +   a21*w11*w13*w33*w51*w52 + a21*w21*w23*w33*w51*w52 + a11*w13*w31*w33*w51*w52 +   a12*w23*w31*w33*w51*w52 - a11*w11*w33^2*w51*w52 - a12*w21*w33^2*w51*w52 -   a22*w13^2*w41*w51*w52 - a22*w23^2*w41*w51*w52 - a22*w33^2*w41*w51*w52 +   a22*w11*w13*w43*w51*w52 + a22*w21*w23*w43*w51*w52 + a22*w31*w33*w43*w51*w52 +   a11*w13*w41*w43*w51*w52 + a12*w23*w41*w43*w51*w52 + a21*w33*w41*w43*w51*w52 -   a11*w11*w43^2*w51*w52 - a12*w21*w43^2*w51*w52 - a21*w31*w43^2*w51*w52 -   w12*w13*w21^2*w53 + w11*w13*w21*w22*w53 + w11*w12*w21*w23*w53 - w11^2*w22*w23*w53 -   w12*w13*w31^2*w53 - w22*w23*w31^2*w53 + w11*w13*w31*w32*w53 + w21*w23*w31*w32*w53 +   w11*w12*w31*w33*w53 + w21*w22*w31*w33*w53 - w11^2*w32*w33*w53 - w21^2*w32*w33*w53 -   w12*w13*w41^2*w53 - w22*w23*w41^2*w53 - w32*w33*w41^2*w53 + w11*w13*w41*w42*w53 +   w21*w23*w41*w42*w53 + w31*w33*w41*w42*w53 + w11*w12*w41*w43*w53 +   w21*w22*w41*w43*w53 + w31*w32*w41*w43*w53 - w11^2*w42*w43*w53 - w21^2*w42*w43*w53 -   w31^2*w42*w43*w53 + a12*w12*w13*w21*w51*w53 - 2*a12*w11*w13*w22*w51*w53 +   a11*w13*w21*w22*w51*w53 + a12*w11*w12*w23*w51*w53 - 2*a11*w12*w21*w23*w51*w53 +   a11*w11*w22*w23*w51*w53 + a21*w12*w13*w31*w51*w53 + a21*w22*w23*w31*w51*w53 -   2*a21*w11*w13*w32*w51*w53 - 2*a21*w21*w23*w32*w51*w53 + a11*w13*w31*w32*w51*w53 +   a12*w23*w31*w32*w51*w53 + a21*w11*w12*w33*w51*w53 + a21*w21*w22*w33*w51*w53 -   2*a11*w12*w31*w33*w51*w53 - 2*a12*w22*w31*w33*w51*w53 + a11*w11*w32*w33*w51*w53 +   a12*w21*w32*w33*w51*w53 + a22*w12*w13*w41*w51*w53 + a22*w22*w23*w41*w51*w53 +   a22*w32*w33*w41*w51*w53 - 2*a22*w11*w13*w42*w51*w53 - 2*a22*w21*w23*w42*w51*w53 -   2*a22*w31*w33*w42*w51*w53 + a11*w13*w41*w42*w51*w53 + a12*w23*w41*w42*w51*w53 +   a21*w33*w41*w42*w51*w53 + a22*w11*w12*w43*w51*w53 + a22*w21*w22*w43*w51*w53 +   a22*w31*w32*w43*w51*w53 - 2*a11*w12*w41*w43*w51*w53 - 2*a12*w22*w41*w43*w51*w53 -   2*a21*w32*w41*w43*w51*w53 + a11*w11*w42*w43*w51*w53 + a12*w21*w42*w43*w51*w53 +   a21*w31*w42*w43*w51*w53 + a12*w11*w13*w21*w52*w53 - a11*w13*w21^2*w52*w53 -   a12*w11^2*w23*w52*w53 + a11*w11*w21*w23*w52*w53 + a21*w11*w13*w31*w52*w53 +   a21*w21*w23*w31*w52*w53 - a11*w13*w31^2*w52*w53 - a12*w23*w31^2*w52*w53 -   a21*w11^2*w33*w52*w53 - a21*w21^2*w33*w52*w53 + a11*w11*w31*w33*w52*w53 +   a12*w21*w31*w33*w52*w53 + a22*w11*w13*w41*w52*w53 + a22*w21*w23*w41*w52*w53 +   a22*w31*w33*w41*w52*w53 - a11*w13*w41^2*w52*w53 - a12*w23*w41^2*w52*w53 -   a21*w33*w41^2*w52*w53 - a22*w11^2*w43*w52*w53 - a22*w21^2*w43*w52*w53 - a22*w31^2*w43*w52*w53 + a11*w11*w41*w43*w52*w53 + a12*w21*w41*w43*w52*w53 +   a21*w31*w41*w43*w52*w53 - a12*w11*w12*w21*w53^2 + a11*w12*w21^2*w53^2 +   a12*w11^2*w22*w53^2 - a11*w11*w21*w22*w53^2 - a21*w11*w12*w31*w53^2 -   a21*w21*w22*w31*w53^2 + a11*w12*w31^2*w53^2 + a12*w22*w31^2*w53^2 +   a21*w11^2*w32*w53^2 + a21*w21^2*w32*w53^2 - a11*w11*w31*w32*w53^2 -   a12*w21*w31*w32*w53^2 - a22*w11*w12*w41*w53^2 - a22*w21*w22*w41*w53^2 -   a22*w31*w32*w41*w53^2 + a11*w12*w41^2*w53^2 + a12*w22*w41^2*w53^2 +   a21*w32*w41^2*w53^2 + a22*w11^2*w42*w53^2 + a22*w21^2*w42*w53^2 +   a22*w31^2*w42*w53^2 - a11*w11*w41*w42*w53^2 - a12*w21*w41*w42*w53^2 -   a21*w31*w41*w42*w53^2)/(w12*w13*w21*w22*w51 - w11*w13*w22^2*w51 - w12^2*w21*w23*w51 +   w11*w12*w22*w23*w51 + w12*w13*w31*w32*w51 + w22*w23*w31*w32*w51 - w11*w13*w32^2*w51 -   w21*w23*w32^2*w51 - w12^2*w31*w33*w51 - w22^2*w31*w33*w51 + w11*w12*w32*w33*w51 +   w21*w22*w32*w33*w51 + w12*w13*w41*w42*w51 + w22*w23*w41*w42*w51 +   w32*w33*w41*w42*w51 - w11*w13*w42^2*w51 - w21*w23*w42^2*w51 - w31*w33*w42^2*w51 -   w12^2*w41*w43*w51 - w22^2*w41*w43*w51 - w32^2*w41*w43*w51 + w11*w12*w42*w43*w51 +   w21*w22*w42*w43*w51 + w31*w32*w42*w43*w51 - a12*w12*w13*w22*w51^2 +   a11*w13*w22^2*w51^2 + a12*w12^2*w23*w51^2 - a11*w12*w22*w23*w51^2 -   a21*w12*w13*w32*w51^2 - a21*w22*w23*w32*w51^2 + a11*w13*w32^2*w51^2 +   a12*w23*w32^2*w51^2 + a21*w12^2*w33*w51^2 + a21*w22^2*w33*w51^2 -   a11*w12*w32*w33*w51^2 - a12*w22*w32*w33*w51^2 - a22*w12*w13*w42*w51^2 -   a22*w22*w23*w42*w51^2 - a22*w32*w33*w42*w51^2 + a11*w13*w42^2*w51^2 +   a12*w23*w42^2*w51^2 + a21*w33*w42^2*w51^2 + a22*w12^2*w43*w51^2 +   a22*w22^2*w43*w51^2 + a22*w32^2*w43*w51^2 - a11*w12*w42*w43*w51^2 -   a12*w22*w42*w43*w51^2 - a21*w32*w42*w43*w51^2 - w12*w13*w21^2*w52 +   w11*w13*w21*w22*w52 + w11*w12*w21*w23*w52 - w11^2*w22*w23*w52 - w12*w13*w31^2*w52 -   w22*w23*w31^2*w52 + w11*w13*w31*w32*w52 + w21*w23*w31*w32*w52 + w11*w12*w31*w33*w52 +   w21*w22*w31*w33*w52 - w11^2*w32*w33*w52 - w21^2*w32*w33*w52 - w12*w13*w41^2*w52 -   w22*w23*w41^2*w52 - w32*w33*w41^2*w52 + w11*w13*w41*w42*w52 + w21*w23*w41*w42*w52 +   w31*w33*w41*w42*w52 + w11*w12*w41*w43*w52 + w21*w22*w41*w43*w52 +   w31*w32*w41*w43*w52 - w11^2*w42*w43*w52 - w21^2*w42*w43*w52 - w31^2*w42*w43*w52 +   a12*w12*w13*w21*w51*w52 + a12*w11*w13*w22*w51*w52 - 2*a11*w13*w21*w22*w51*w52 -   2*a12*w11*w12*w23*w51*w52 + a11*w12*w21*w23*w51*w52 + a11*w11*w22*w23*w51*w52 +   a21*w12*w13*w31*w51*w52 + a21*w22*w23*w31*w51*w52 + a21*w11*w13*w32*w51*w52 +   a21*w21*w23*w32*w51*w52 - 2*a11*w13*w31*w32*w51*w52 - 2*a12*w23*w31*w32*w51*w52 -   2*a21*w11*w12*w33*w51*w52 - 2*a21*w21*w22*w33*w51*w52 + a11*w12*w31*w33*w51*w52 +   a12*w22*w31*w33*w51*w52 + a11*w11*w32*w33*w51*w52 + a12*w21*w32*w33*w51*w52 +   a22*w12*w13*w41*w51*w52 + a22*w22*w23*w41*w51*w52 + a22*w32*w33*w41*w51*w52 +   a22*w11*w13*w42*w51*w52 + a22*w21*w23*w42*w51*w52 + a22*w31*w33*w42*w51*w52 -   2*a11*w13*w41*w42*w51*w52 - 2*a12*w23*w41*w42*w51*w52 - 2*a21*w33*w41*w42*w51*w52 -   2*a22*w11*w12*w43*w51*w52 - 2*a22*w21*w22*w43*w51*w52 - 2*a22*w31*w32*w43*w51*w52 +   a11*w12*w41*w43*w51*w52 + a12*w22*w41*w43*w51*w52 + a21*w32*w41*w43*w51*w52 +   a11*w11*w42*w43*w51*w52 + a12*w21*w42*w43*w51*w52 + a21*w31*w42*w43*w51*w52 -   a12*w11*w13*w21*w52^2 + a11*w13*w21^2*w52^2 + a12*w11^2*w23*w52^2 -   a11*w11*w21*w23*w52^2 - a21*w11*w13*w31*w52^2 - a21*w21*w23*w31*w52^2 +   a11*w13*w31^2*w52^2 + a12*w23*w31^2*w52^2 + a21*w11^2*w33*w52^2 +   a21*w21^2*w33*w52^2 - a11*w11*w31*w33*w52^2 - a12*w21*w31*w33*w52^2 -   a22*w11*w13*w41*w52^2 - a22*w21*w23*w41*w52^2 - a22*w31*w33*w41*w52^2 +    a11*w13*w41^2*w52^2 + a12*w23*w41^2*w52^2 + a21*w33*w41^2*w52^2 +   a22*w11^2*w43*w52^2 + a22*w21^2*w43*w52^2 + a22*w31^2*w43*w52^2 -   a11*w11*w41*w43*w52^2 - a12*w21*w41*w43*w52^2 - a21*w31*w41*w43*w52^2 +   w12^2*w21^2*w53 - 2*w11*w12*w21*w22*w53 + w11^2*w22^2*w53 + w12^2*w31^2*w53 +   w22^2*w31^2*w53 - 2*w11*w12*w31*w32*w53 - 2*w21*w22*w31*w32*w53 + w11^2*w32^2*w53 +   w21^2*w32^2*w53 + w12^2*w41^2*w53 + w22^2*w41^2*w53 + w32^2*w41^2*w53 -   2*w11*w12*w41*w42*w53 - 2*w21*w22*w41*w42*w53 - 2*w31*w32*w41*w42*w53 +   w11^2*w42^2*w53 + w21^2*w42^2*w53 + w31^2*w42^2*w53 - a12*w12^2*w21*w51*w53 +   a12*w11*w12*w22*w51*w53 + a11*w12*w21*w22*w51*w53 - a11*w11*w22^2*w51*w53 -   a21*w12^2*w31*w51*w53 - a21*w22^2*w31*w51*w53 + a21*w11*w12*w32*w51*w53 +   a21*w21*w22*w32*w51*w53 + a11*w12*w31*w32*w51*w53 + a12*w22*w31*w32*w51*w53 -   a11*w11*w32^2*w51*w53 - a12*w21*w32^2*w51*w53 - a22*w12^2*w41*w51*w53 -   a22*w22^2*w41*w51*w53 - a22*w32^2*w41*w51*w53 + a22*w11*w12*w42*w51*w53 +   a22*w21*w22*w42*w51*w53 + a22*w31*w32*w42*w51*w53 + a11*w12*w41*w42*w51*w53 +   a12*w22*w41*w42*w51*w53 + a21*w32*w41*w42*w51*w53 - a11*w11*w42^2*w51*w53 -   a12*w21*w42^2*w51*w53 - a21*w31*w42^2*w51*w53 + a12*w11*w12*w21*w52*w53 -   a11*w12*w21^2*w52*w53 - a12*w11^2*w22*w52*w53 + a11*w11*w21*w22*w52*w53 +   a21*w11*w12*w31*w52*w53 + a21*w21*w22*w31*w52*w53 - a11*w12*w31^2*w52*w53 -   a12*w22*w31^2*w52*w53 - a21*w11^2*w32*w52*w53 - a21*w21^2*w32*w52*w53 +  a11*w11*w31*w32*w52*w53 + a12*w21*w31*w32*w52*w53 + a22*w11*w12*w41*w52*w53 +   a22*w21*w22*w41*w52*w53 + a22*w31*w32*w41*w52*w53 - a11*w12*w41^2*w52*w53 -   a12*w22*w41^2*w52*w53 - a21*w32*w41^2*w52*w53 - a22*w11^2*w42*w52*w53 -   a22*w21^2*w42*w52*w53 - a22*w31^2*w42*w52*w53 + a11*w11*w41*w42*w52*w53 +   a12*w21*w41*w42*w52*w53 + a21*w31*w41*w42*w52*w53);
  
  
  
n1=-((-(w13^2*w51) - w23^2*w51 - w33^2*w51 - w43^2*w51 +    n2^2*(-(w12^2*w51) - w22^2*w51 - w32^2*w51 - w42^2*w51 + w31*w32*w52 + w41*w42*w52 +      a21*w32*w51*w52 + a22*w42*w51*w52 + w12*(w11 + a11*w51)*w52 +       w22*(w21 + a12*w51)*w52 - a11*w11*w52^2 - a12*w21*w52^2 - a21*w31*w52^2 -      a22*w41*w52^2) + w21*w23*w53 + w31*w33*w53 + w41*w43*w53 + a12*w23*w51*w53 +    a21*w33*w51*w53 + a22*w43*w51*w53 + w13*(w11 + a11*w51)*w53 - a11*w11*w53^2 -    a12*w21*w53^2 - a21*w31*w53^2 - a22*w41*w53^2 +    n2*(-2*w12*w13*w51 - 2*w22*w23*w51 - 2*w32*w33*w51 - 2*w42*w43*w51 + w11*w13*w52 +      w21*w23*w52 + w31*w33*w52 + w41*w43*w52 + a11*w13*w51*w52 + a12*w23*w51*w52 +      a21*w33*w51*w52 + a22*w43*w51*w52 + w31*w32*w53 + w41*w42*w53 + a21*w32*w51*w53 +      a22*w42*w51*w53 + w12*(w11 + a11*w51)*w53 + w22*(w21 + a12*w51)*w53 -      2*a11*w11*w52*w53 - 2*a12*w21*w52*w53 - 2*a21*w31*w52*w53 - 2*a22*w41*w52*w53))/   (-(w21*w23*w51) - w31*w33*w51 - w41*w43*w51 + a11*w13*w51^2 + a12*w23*w51^2 +    a21*w33*w51^2 + a22*w43*w51^2 + n2*(-(w31*w32*w51) - w41*w42*w51 + a11*w12*w51^2 +      a12*w22*w51^2 + a21*w32*w51^2 + a22*w42*w51^2 + w11^2*w52 + w21^2*w52 + w31^2*w52 +      w41^2*w52 - a21*w31*w51*w52 - a22*w41*w51*w52 - w11*w51*(w12 + a11*w52) -      w21*w51*(w22 + a12*w52)) + w11^2*w53 + w21^2*w53 + w31^2*w53 + w41^2*w53 -    a12*w21*w51*w53 - a21*w31*w51*w53 - a22*w41*w51*w53 - w11*w51*(w13 + a11*w53)));


switch(mode)
    case 1
        n=[n1;n2;1.0];
    case 2
        n=[n1;1.0;n2];
    case 3
        n=[1.0;n2;n1];
end

nEst=n/norm(n);

end

