%object:
%1: sphere
%2: general plane
%3: vercical plane: n=[cos(alpha) 0 sin(alpha)]
%4: very special plane: n=[1 0 0]
%5: very special plane: n=[0 1 0]
%6: very special plane: n=[0 0 1]

%Object:
%1: sphere
%2: general plane
%3: vercical plane: n=[cos(alpha) 0 sin(alpha)]
%4: very special plane: n=[1 0 0]
%5: very special plane: n=[0 1 0]
%6: very special plane: n=[0 0 1]


%testMode:
% 1 pure planar (rot+translate direction)
% 2 Quarocopter: (rot + arbitrary translate in 3D)
# 3: Moto : TODO
# 4: Pure planar + unknown focal length
# 5: planar motion + C1=C2=eye(3)
# 6: planar sideways motion + C1=C2=eye(3)
# 7: planar forward motion + C1=C2=eye(3)



function [pts3D,normals,first2D,second2D,As,P1,P2,EGT,C1,R1,t1,C2,R2,t2,R,t]=TestDataGenerator(object,testMode,ptsNoise=0.0,affineNoise=0.0)

  
  %Generate surface
  [pts3D,normals]=GenerateSurface(object,100);
  
  
%!!!!!!
%Test variants
%

%General camera
  [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(0,2,2);

%standard stereo 'Normal from homography' version does not work
%  [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(4,2,2);


%planar motion : 'Normal from homography' version does not work
%  [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(1,2,2);

%quadcopter
%  [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(2,2,2);

%moto
%  [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(3,2,2);


C1
R1
t1

C2
R2
t2
%pause
  
  %Generate camera pair

%  if (testMode==1)
%    [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(1,0,2);
%    elseif (testMode==2)
%    [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(2,0,2);
%    elseif (testMode==3)
%        [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(3,4,2);
%    elseif (testMode==4)
%        [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(1,3,1);
%    elseif (testMode==5)
%        [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(1,4,1);
%    elseif (testMode==6)
%        [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(4,4,1);
%    elseif (testMode==7)
%        [P1,C1,R1,t1,P2,C2,R2,t2,R,t,Tx,EGT]=GenerateCameras(5,4,1);
%    endif

    
  
    

  NUMP=size(normals,1);
  
  first2D=zeros(NUMP,2);
  second2D=zeros(NUMP,2);
  
  As=zeros(2*NUMP,2);
  
  T1=[R1,t1;0,0,0,1];
  T2=[R2,t2;0,0,0,1];
  
  for idx=1:NUMP
    pt3D=pts3D(idx,:)';
    n=normals(idx,:)';
    
    
    
    fst=P1*[pt3D;1];
    fst=fst/fst(3);
    
    snd=P2*[pt3D;1];
    snd=snd/snd(3);
    
    first2D(idx,1:2)=fst(1:2)';
    second2D(idx,1:2)=snd(1:2)';
    
%    dirs=null(n');
%    dir1=dirs(:,1);
%    dir2=dirs(:,2);

    [~,~,dirs_tmp]=svd(n');
    dir1=dirs_tmp(:,2);
    dir2=dirs_tmp(:,3);

    
    Rcurr=[dir1';dir2';n'];
    [eye(3),-pt3D];
    T=[Rcurr*[[eye(3),-pt3D]];[0,0,0,1]];
    
    H1=T1*inv(T);
    H1=H1(1:3,[1,2,4]);
    H1=C1*H1;
    
    H2=T2*inv(T);
    H2=H2(1:3,[1,2,4]);
    H2=C2*H2;
    
    Hcurr=H2*inv(H1);
    
%Check:
    sCand=Hcurr*fst;
    sCand=sCand/sCand(3);
    
    Acurr=GetAffineFromHomography(Hcurr,fst(1),fst(2),snd(1),snd(2))
    Acurr_tmp=Acurr

%Add noise

    [rot1,scales,rot2]=svd(Acurr);
    d1=det(rot1);
    d2=det(rot2);

    angle1=atan2(-rot1(1,2),rot1(1,1));
    angle2=atan2(-rot2(1,2),rot2(1,1));

    angle1=angle1+randn*affineNoise;
    rot1=[cos(angle1),-1.0*sin(angle1);sin(angle1),cos(angle1)];
    rot1(2,:)=d1*rot1(2,:);

    angle2=angle2+randn*affineNoise;
    rot2=[cos(angle2),-1.0*sin(angle2);sin(angle2),cos(angle2)];
    rot2(2,:)=d2*rot2(2,:);

    scales(1,1)=scales(1,1)+randn*affineNoise;
    scales(2,2)=scales(2,2)+randn*affineNoise;

    Acurr=rot1*scales*rot2'
    As(2*idx-1:2*idx,1:2)=Acurr;
%    As(2*idx-1:2*idx,1:2)=Acurr_tmp+affineNoise*randn(2,2)
  endfor

  first2D=first2D+ptsNoise*randn(size(first2D));
  second2D=second2D+ptsNoise*randn(size(second2D));
  


  
end
