REPEATNUM=100;

NOISE_PTS=0.0:1.0:10.0

meanEstFNE=[];
meanEstFNESuper=[];
meanOPT=[];
meanCubic=[];
meanRapid=[];
meanHomography=[];

medianEstFNE=[];
medianEstFNESuper=[];
medianOPT=[];
medianCubic=[];
medianRapid=[];
medianHomography=[];


for noiseLevel=NOISE_PTS

    errsEstFNE=0.0;
    errsEstFNESuper=0.0;
    errsOPT=0.0;
    errsCubic=0.0;
    errsRapid=0.0;
    errsHomography=0.0;

    [errsEstFNE,errsEstFNESuper,errsOPT,errsCubic,errsRapid,errsHomography]=TestSystem(noiseLevel,noiseLevel/4000,REPEATNUM)
%    pause


    "---------- Median --------------"

%    "FNE"
    medianEstFNE=[medianEstFNE;median(errsEstFNE)]

%    "FNE Super"
    medianEstFNESuper=[medianEstFNESuper;median(errsEstFNESuper)]

%    "OPT"
    medianOPT=[medianOPT;median(errsOPT)]

%    "Cubic"
    medianCubic=[medianCubic;median(errsCubic)]

%    "Rapid"
    medianRapid=[medianRapid;median(errsRapid)]

%    "Homography"
    medianHomography=[medianHomography;median(errsHomography)]


    "----------- Mean ---------------"

%    "FNE"
    meanEstFNE=[meanEstFNE;mean(errsEstFNE)]

%    "FNE Super"
    meanEstFNESuper=[meanEstFNESuper;mean(errsEstFNESuper)]

%    "OPT"
    meanOPT=[meanOPT;mean(errsOPT)]

%    "Cubic"
    meanCubic=[meanCubic;mean(errsCubic)]

%    "Rapid"
    meanRapid=[meanRapid;mean(errsRapid)]

%    "Homography"
    meanHomography=[meanHomography;mean(errsHomography)]

endfor


NOISE_PTS'
medianEstFNE


    medianErrors=[NOISE_PTS',medianEstFNE,medianEstFNESuper,medianOPT,medianCubic,medianRapid,medianHomography];

    meanErrors=[NOISE_PTS',meanEstFNE,meanEstFNESuper,meanOPT,meanCubic,meanRapid,meanHomography];

    save("medianCombinedErrors.mat","-ascii","medianErrors")
    save("meanCombinedErrors.mat","-ascii","meanErrors")
