#include "HajderTriangulation.h"


Point3f LinearTriangulation(Mat P1,float u1,float v1,Mat P2,float u2,float v2){
/*    
	A=[P1(1,1)-u1*P1(3,1),P1(1,2)-u1*P1(3,2),P1(1,3)-u1*P1(3,3); 
	P1(2,1)-v1*P1(3,1),P1(2,2)-v1*P1(3,2),P1(2,3)-v1*P1(3,3); 
	P2(1,1)-u2*P2(3,1),P2(1,2)-u2*P2(3,2),P2(1,3)-u2*P2(3,3); 
	P2(2,1)-v2*P2(3,1),P2(2,2)-v2*P2(3,2),P2(2,3)-v2*P2(3,3);];
	b=[u1*P1(3,4)-P1(1,4) ;v1*P1(3,4)-P1(2,4);u2*P2(3,4)-P2(1,4);v2*P2(3,4)-P2(2,4)];
	pt3D=pinv(A)*b;
*/

    Mat A(4,3,CV_32F);
    
    A.at<float>(0,0)=P1.at<float>(0,0)-u1*P1.at<float>(2,0);
    A.at<float>(0,1)=P1.at<float>(0,1)-u1*P1.at<float>(2,1);
    A.at<float>(0,2)=P1.at<float>(0,2)-u1*P1.at<float>(2,2);


    A.at<float>(1,0)=P1.at<float>(1,0)-v1*P1.at<float>(2,0);
    A.at<float>(1,1)=P1.at<float>(1,1)-v1*P1.at<float>(2,1);
    A.at<float>(1,2)=P1.at<float>(1,2)-v1*P1.at<float>(2,2);

    A.at<float>(2,0)=P2.at<float>(0,0)-u2*P2.at<float>(2,0);
    A.at<float>(2,1)=P2.at<float>(0,1)-u2*P2.at<float>(2,1);
    A.at<float>(2,2)=P2.at<float>(0,2)-u2*P2.at<float>(2,2);

    A.at<float>(3,0)=P2.at<float>(1,0)-v2*P2.at<float>(2,0);
    A.at<float>(3,1)=P2.at<float>(1,1)-v2*P2.at<float>(2,1);
    A.at<float>(3,2)=P2.at<float>(1,2)-v2*P2.at<float>(2,2);

    Mat b(4,1,CV_32F);

    b.at<float>(0,0)=u1*P1.at<float>(2,3)-P1.at<float>(0,3);
    b.at<float>(1,0)=v1*P1.at<float>(2,3)-P1.at<float>(1,3);
    b.at<float>(2,0)=u2*P2.at<float>(2,3)-P2.at<float>(0,3);
    b.at<float>(3,0)=v2*P2.at<float>(2,3)-P2.at<float>(1,3);


    Mat resM=(A.t()*A).inv()*A.t()*b;
    
    Point3f res;
    res.x=resM.at<float>(0,0);
    res.y=resM.at<float>(1,0);
    res.z=resM.at<float>(2,0);


    return res;
}
