#ifndef NORMAL_ESTIMATION
#define NORMAL_ESTIMATION

#include<opencv2/core.hpp>
#include "HajderTriangulation.h"
#include "HartleySturm.h"
#include "PolyUtility.h"


#include<iostream>

using namespace cv;
using namespace std;

Point3f FNE1(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2);
Point3f FNE2(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2);
Point3f FNE3(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2);
Point3f FNESuper(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2);


Point3f OPT(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2);
Point3f CubicOpt(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2);

Point3f RapidOPT(Mat A,Mat P1,Mat P2,float u1,float v1,float u2,float v2);  //By Lajos Loczi



Point3f CalculateGradientsForU(Mat P,float u,float X,float Y,float Z);
Point3f CalculateGradientsForV(Mat P,float v,float X,float Y,float Z);

Point3f CoreOptimizator(Mat, Mat, float);


vector<Point2f> spec_kvadratikus(float,float,float,float,float,float,float,float,float,float);

float getOptError(Point3f n,float alpha,Point3f p1,Point3f p2,Point3f p3,Point3f p4,Point3f p5,float a1,float a2,float a3,float a4);


#endif
