import numpy as np

from options import RendererOptions
from render_wrapper import Renderer

import utils.general as utils

import os
import pickle

from PIL import Image
import numpy as np

import utils.general as utils

if __name__ == '__main__':
    renderer = Renderer(RendererOptions())



    intrinsics = renderer.get_intrinsics(60)
    poses = renderer.get_pose_from_angles(1.7, [np.pi/2], [0, 3*np.pi/2])

    out_dir = '../data/boy'
    os.makedirs(os.path.join(out_dir, 'bases'), exist_ok = True)
    os.makedirs(os.path.join(out_dir, 'shapes'), exist_ok = True)






    for i in range(len(poses)):
        image = renderer.get_image(poses[i].unsqueeze(0), intrinsics, return_pil = False, save_path=None, disable_bg = True)


        silhouette = renderer.get_image(poses[i].unsqueeze(0), intrinsics, return_pil = False, save_path=None, output_type = 'silhouette')
        silhouette[silhouette >= 0.5] = 1
        silhouette[silhouette < 0.5] = 0
        utils.save_tensor_image(image, os.path.join(out_dir, 'bases/canvas_0{}.png'.format(i)))
        utils.save_tensor_image(silhouette, os.path.join(out_dir, 'shapes/canvas_0{}.png'.format(i)))
    meta_data = {
        'intrinsics' : intrinsics,
        'poses' : poses,
    }
    with open(os.path.join(out_dir, 'meta_data.pkl'), 'wb') as f:
        pickle.dump(meta_data, f)