Dataset
-----
### Dataset download
We download the datasets ImageNet, Hanzi, BSD68 from the public repo of [Noise2Same](https://github.com/divelab/Noise2Same/tree/main/Denoising_data). The SIDD dataset is downloaded from [SIDD](https://www.eecs.yorku.ca/~kamel/sidd/index.php)

### ImageNet 
We follow [Noise2Same](https://github.com/divelab/Noise2Same/tree/main/Denoising_data) to generate noisy images based on public clear images. For consistency, we apply noises including Poisson noise ($\lambda = 30$), additive Gaussian noise ($\mu = 0, \sigma = 60$) and Bernoulli noise ($p = 0.2$). The training dataset contains 60,000 randomly cropped patches of size 128 x 128 from the first 20,000 images in ILSVRC2012 Val while validation and testing datasets are consists of two sets of 1,000 images from ILSVRC2012 Val.

### HànZì
We adopt generator of HànZì dataset from [Noise2Self](https://arxiv.org/abs/1901.11365). The original dataset contains 13029 Chinese characters. 26058 noisy images of size 64 x 64 are generated by applying Gaussian noise ($\sigma = 0.7$) and Bernoulli noise to a clear Chinese character image. The training and testing datasets are split into 9:1. In addition, we modify the generator to construct datasets with varied scale of Gaussian noise; varies types of noise including Gaussian noise, Logistic noise, Uniform noise, Mixed noise of these three, Poisson-Gaussian, and Pepper noise. The code is given in ```Denoising_Data/Hanzi/generate.py```

### BSD68
We obtain BSD68 Dataset following [Noise2Void](https://arxiv.org/abs/1811.10980). 400 grey-scale version of images are applied with Gaussian noise ($\sigma = 25$) and cropped into patches of size 180 x 180 for training. 68 pairs of images are used for testing.

### SIDD
SIDD is a real world dataset contains 320 images for training and 1280 images pairs for testing. We download the dataset and fit it to our input format using code in ```Denoising_Data/SIDD/train_test_gen.py```

