from hmvit.data_utils.pre_processor.base_preprocessor import BasePreprocessor
from hmvit.data_utils.pre_processor.voxel_preprocessor import VoxelPreprocessor
from hmvit.data_utils.pre_processor.bev_preprocessor import BevPreprocessor
from hmvit.data_utils.pre_processor.sp_voxel_preprocessor import SpVoxelPreprocessor
from hmvit.data_utils.pre_processor.rgb_preprocessor import RgbPreProcessor
from hmvit.data_utils.pre_processor.rgb_lidar_preprocessor import CamLiPreprocessor


__all__ = {
    'BasePreprocessor': BasePreprocessor,
    'VoxelPreprocessor': VoxelPreprocessor,
    'BevPreprocessor': BevPreprocessor,
    'SpVoxelPreprocessor': SpVoxelPreprocessor,
    'RgbPreprocessor': RgbPreProcessor,
    'CamLiPreprocessor': CamLiPreprocessor
}


def build_preprocessor(preprocess_cfg, train):
    process_method_name = preprocess_cfg['core_method']
    error_message = f"{process_method_name} is not found. " \
                     f"Please add your processor file's name in hmvit/" \
                     f"data_utils/processor/init.py"
    assert process_method_name in __all__.keys(), error_message

    processor = __all__[process_method_name](
        preprocess_params=preprocess_cfg,
        train=train
    )

    return processor
