import numpy as np
import random
import tensorflow as tf
from tensorflow.examples.tutorials.mnist import input_data 


#the parameters of the algorithm
BatchLength= 64 #batches of 32 images are processed and averaged out
Size=[32,32,1]  #size of the input image
NumKernels=[8,16] 
TrainSteps = int(2e3)
TestSteps = int(1e2)
NumClasses=1

def LeakyRelu(x):
    alpha=0.001
    R=tf.maximum(alpha*x,x)
    return R
  

def CreateNetwork(Input):
  Input=tf.reshape(Input,[-1]+Size)
  CurrentFilters=Size[2]
  LayerNum=0
  CurrentInput=Input
  # a loop which creates all layers
  for N in NumKernels:
      with tf.variable_scope('conv'+str(LayerNum)):
        LayerNum+=1
        #variables that we want to optimize
        W =tf.get_variable('W', [3,3,CurrentFilters,N])
        ConvResult = tf.nn.conv2d(CurrentInput,W,strides=[1,1,1,1], padding='SAME')
        
        ConvResult=tf.layers.batch_normalization(ConvResult,training=True)
   
        CurrentFilters=N
        # relu
        ReLU=LeakyRelu(ConvResult)
       

        #continuous implementation of pooling
        PoolStrength =tf.get_variable('PoolStrength', [1,1,1,CurrentFilters],initializer=tf.constant_initializer(0.1)) # this will determine the timestep
        CurrentShape=ReLU.get_shape()

        PoolStrength=tf.tile(PoolStrength,[CurrentShape[0],CurrentShape[1],CurrentShape[2],1]) # this is tiled since this parameter shouldb e the same for an image, but might be different for different layers
        #pool
        for i in range(10):  #for 10 steps
            Pooled=tf.nn.max_pool(ReLU,ksize=[1,3,3,1],strides=[1,1,1,1],padding='SAME') # do a normal pooling - with this we will found larger values
            Diff = Pooled-ReLU #calculate the difference between the image and the larger values - this is how much we should add to the image
            ReLU=ReLU+PoolStrength*Diff  # add a small part (timestep) of the difference to the image
        ReLU=tf.nn.avg_pool(ReLU,ksize=[1,2,2,1],strides=[1,2,2,1],padding='VALID') # I have used average pooling to downscale the image - we coudl also do this by 1x1 strided convolution

        CurrentInput=Pooled
  with tf.variable_scope('FC'):
        CurrentShape=CurrentInput.get_shape()
        FeatureLength = int(CurrentShape[1]*CurrentShape[2]*CurrentShape[3])
        FC = tf.reshape(CurrentInput, [-1, FeatureLength])
        W = tf.get_variable('W',[FeatureLength,NumClasses])
        FC = tf.matmul(FC, W)
        Bias = tf.get_variable('Bias',[NumClasses])
        FC = tf.add(FC, Bias)
  return FC


Input = tf.placeholder(tf.float32,[BatchLength]+Size)
Label  = tf.placeholder(tf.float32,[BatchLength,1])

# create the neural network model
logits=CreateNetwork(Input)


# add the optimizer and loss
loss = tf.reduce_sum(tf.abs(Label-logits))
optimizer = tf.train.AdamOptimizer().minimize(loss)

init_op = tf.global_variables_initializer()

with tf.Session() as sess:
    Saver = tf.train.Saver()
    sess.run(init_op)
    for i in range(TrainSteps):
        InputImg=np.zeros([BatchLength]+Size)
        Labels=np.zeros((BatchLength,1))
        for b in range(BatchLength):
           #generate random sample
           XCoords=np.random.choice(Size[0], size=2, replace=False)
           YCoords=np.random.choice(Size[0], size=2, replace=False)
           Dist=np.square(XCoords[0]-XCoords[1])+np.square(YCoords[0]-YCoords[1])
           Labels[b,0]=Dist
           InputImg[b,XCoords[0],YCoords[0],0]=1
           InputImg[b,XCoords[1],YCoords[1],0]=1	    
        _,  l = sess.run([ optimizer,  loss],feed_dict={Input: InputImg, Label: Labels})
        if i % 100 == 0:
           print("Iteration: "+str(i)+",  training  accuracy: "+str(l))
		          
