import numpy as np
import random
import tensorflow as tf
from tensorflow.examples.tutorials.mnist import input_data 


#read data and display data
mnist = input_data.read_data_sets("../datasets/MNIST_data/") 

#the parameters of the algorithm
BatchLength= 32  #batches of 32 images are processed and averaged out
Size=[28,28,1]  #size of the input image
NumKernels=[8,16,32] 
TrainSteps = int(2e3)
TestSteps = int(1e2)
NumClasses=10

def LeakyRelu(x):
    alpha=0.001
    R=tf.maximum(alpha*x,x)
    return R
  

def CreateNetwork(Input):
  Input=tf.reshape(Input,[-1]+Size)
  CurrentFilters=Size[2]
  LayerNum=0
  CurrentInput=Input
  # a loop which creates all layers
  for N in NumKernels:
      with tf.variable_scope('conv'+str(LayerNum)):
        LayerNum+=1

        
        #variables that we want to optimize - regular convolution
        W =tf.get_variable('W1', [3,3,CurrentFilters,N])
        CurrentInput = tf.nn.conv2d(CurrentInput,W,strides=[1,1,1,1], padding='SAME')
        
        #continuous convolution  - this was commented out, becasue, first just start with pooling 
        #W =tf.get_variable('WCont', [3,3,N,N])
        #ConvStrength =tf.get_variable('ConvStrength', [1,1,1,N],initializer=tf.constant_initializer(0.1))
        #CurrentShape=CurrentInput.get_shape()
        #ConvStrength=tf.tile(ConvStrength,[CurrentShape[0],CurrentShape[1],CurrentShape[2],1])
        #for i in range(10):  
        #    ConvResult = tf.nn.conv2d(CurrentInput,W,strides=[1,1,1,1], padding='SAME')
        #    CurrentInput=CurrentInput+ConvStrength*ConvResult
        

        
        ConvResult=tf.layers.batch_normalization(CurrentInput,training=True)
   
        CurrentFilters=N
        # relu
        ReLU=LeakyRelu(ConvResult)
       
        #pool - stnadard pooling
        #Pooled=tf.nn.max_pool(ReLU,ksize=[1,3,3,1],strides=[1,1,1,1],padding='VALID')

        #continuous implementation of pooling
        PoolStrength =tf.get_variable('PoolStrength', [1,1,1,CurrentFilters],initializer=tf.constant_initializer(0.1)) # this will determine the timestep
        CurrentShape=ReLU.get_shape()

        PoolStrength=tf.tile(PoolStrength,[CurrentShape[0],CurrentShape[1],CurrentShape[2],1]) # this is tiled since this parameter shouldb e the same for an image, but might be different for different layers
        #implementaiton of the pooling operation
        for i in range(10):  #for 10 steps
            Pooled=tf.nn.max_pool(ReLU,ksize=[1,3,3,1],strides=[1,1,1,1],padding='SAME') # do a normal pooling - with this we will found larger values
            Diff = Pooled-ReLU #calculate the difference between the image and the larger values - this is how much we should add to the image
            ReLU=ReLU+PoolStrength*Diff  # add a small part (timestep) of the difference to the image
        ReLU=tf.nn.avg_pool(ReLU,ksize=[1,2,2,1],strides=[1,2,2,1],padding='VALID') # I have used average pooling to downscale the image - we coudl also do this by 1x1 strided convolution

        CurrentInput=ReLU
  with tf.variable_scope('FC'):
        CurrentShape=CurrentInput.get_shape()
        FeatureLength = int(CurrentShape[1]*CurrentShape[2]*CurrentShape[3])
        FC = tf.reshape(CurrentInput, [-1, FeatureLength])
        W = tf.get_variable('W',[FeatureLength,NumClasses])
        FC = tf.matmul(FC, W)
        Bias = tf.get_variable('Bias',[NumClasses])
        FC = tf.add(FC, Bias)
  return FC


Input = tf.placeholder(tf.float32,[BatchLength]+Size)
Label  = tf.placeholder(tf.int64,[BatchLength])

# create the neural network model
logits=CreateNetwork(Input)
sf=tf.nn.softmax(logits)

# add the optimizer and loss
loss = tf.reduce_sum(tf.nn.sparse_softmax_cross_entropy_with_logits(labels=Label, logits=logits))
optimizer = tf.train.AdamOptimizer().minimize(loss)

# get accuracy
prediction = tf.argmax(logits, 1)
equality = tf.equal(prediction, Label)
accuracy = tf.reduce_mean(tf.cast(equality, tf.float32))

init_op = tf.global_variables_initializer()

RepeatNum=10
TrainAcc=[]
TestAcc=[]
for r in range(RepeatNum):
		with tf.Session() as sess:
		    Saver = tf.train.Saver()
		    sess.run(init_op)
		    TestAccSmall=[]		
		    TrainAccSmall=[]		    
		    
		    for i in range(TrainSteps):
		        SelectedIndices=np.random.choice(mnist.train.images.shape[0], BatchLength, replace=False)
		        in_c=mnist.train.images[SelectedIndices]
		        in_c=np.reshape(in_c,[BatchLength]+Size)	
		        l=mnist.train.labels[SelectedIndices]		    
		        _,  acc = sess.run([ optimizer,  accuracy],feed_dict={Input: in_c, Label: l})
		        if i % 100 == 0:
		           print("Iteration: "+str(i)+",  training  accuracy: "+str(acc))
		           TrainAccSmall.append(acc)  
		           
		           avg_acc = 0
		           for x in range(TestSteps):
		              SelectedIndices=np.random.choice(mnist.test.images.shape[0], BatchLength, replace=False)
		              in_c=mnist.test.images[SelectedIndices]
		              in_c=np.reshape(in_c,[BatchLength]+Size)	
		              l=mnist.test.labels[SelectedIndices]		    
		        
		              acc= sess.run(accuracy,feed_dict={Input: in_c, Label: l})
		              avg_acc += acc
		           print("Test acc: "+str((avg_acc / TestSteps) * 100))
		           TestAccSmall.append((avg_acc / TestSteps))  
		    TrainAcc.append(TrainAccSmall)
		    TestAcc.append(TestAccSmall)
		    #print(Saver.save(sess, "./checkpoint_normal/mymodel"))
np.save('MNISTContTrain.npy',TrainAcc)
np.save('MNISTContTest.npy',TestAcc)	
