# -*- coding: utf-8 -*-
"""utils.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1YSxZ2E-9yasR6mmsQVZ_28r20_dvEEl1
"""

#!/usr/bin/env python
# coding: utf-8

# In[5]:


import cv2
import numpy as np
from matplotlib import pyplot as plt
import torch
from skimage import draw
import skimage
from imutils import face_utils
import imutils
import collections
import os
import seaborn as sns
import glob
from math import *

from torch.utils.data import Dataset
from torch.utils.data import DataLoader
from torch.autograd import Variable
from sklearn.metrics import roc_curve, auc
from sklearn import svm
import itertools
import pandas as pd

import random
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
from scipy import stats
from mpl_toolkits import mplot3d

from sklearn import tree

from torchsummary import summary

# In[2]:


def landmark_coordinate(txt_str):
    txt_process = txt_str[:-1]
    txt_process = txt_process.split(', ')
    for i in range(len(txt_process)):
        try:
            txt_process[i] = txt_process[i].replace('[', '')
        except:
            None
        try:
            txt_process[i] = txt_process[i].replace(']', '')
        except:
            None
    result = [] 
    for j in range(int(len(txt_process) / 2)):
        result.append([int(txt_process[2 * j]) , int(txt_process[2 * j + 1])])
    
    return np.array(result)


# In[3]:


def linearF(P, Q):
    a = P[0]
    b = P[1]
    c = Q[0]
    d = Q[1]
    
    vec = np.array([c - a, d - b])
    size = sqrt((c - a)**2 + (d - b)**2)
    const = (b * vec[0]) - (a * vec[1])
    return list([vec, size, const])


# In[4]:


def vertical_vec(P, Q, num=10, Scaling=1):
    a = P[0]
    b = P[1]
    c = Q[0]
    d = Q[1]
    
    mid_p_x = (a + c) / 2
    mid_p_y = (b + d) / 2
    vec_size = sqrt(((b - d)**2 + (a - c)**2) / Scaling)
    t = np.arange(-num, num)
    result_x = (b - d) * t / vec_size + mid_p_x
    result_y = (c - a) * t / vec_size + mid_p_y
    return np.array([result_x, result_y])


# In[6]:


def wide_line(p_x, p_y, vec, num=10, Scaling=1):
    
    vec_size = sqrt(((vec[0] ** 2) + (vec[1] ** 2)) / Scaling)
    t = np.arange(-num, num)
    
    result_x = vec[0] * t * sqrt(Scaling) / 27 + p_x #vec[1] * t / vec_size + p_y
    result_y = vec[1] * t * sqrt(Scaling) / 27 + p_y #vec[1] * t / vec_size + p_y
    return np.array([result_x, result_y])


# In[7]:


def vertical_vec_bg(vec, ctr, num=10, Scaling=1):
    x = ctr[1]
    y = ctr[0]
    x_v = vec[0]
    y_v = - vec[1]
    vec_size = sqrt(2 / Scaling)
    t = np.arange(-num, num)
    result_x = x_v * t / vec_size + x
    result_y = y_v * t / vec_size + y
    return np.array([result_x, result_y])


# In[8]:


def sample_points(edge_img, points = 16):
    th_h = int(edge_img.shape[0] / 10)
    th_w = int(edge_img.shape[1] / 10)
    cropped = edge_img[th_h:-th_h, th_w:-th_w]
    result = np.zeros((2, points))
    nonzero_points = np.array(np.nonzero(cropped))
    length = nonzero_points.shape[1]
    sampled = np.random.choice(length, points, replace=False)
    for i in range(points):
        result[:, i] = nonzero_points[:, sampled[i]]
        result[0, i] += th_h
        result[1, i] += th_w
    return result.astype(int)


# In[9]:


def nearestpad(edge_img, pos):
    return edge_img[(pos[0] - 1):(pos[0] + 2), (pos[1] - 1):(pos[1] + 2)]


# In[10]:


def nearest_angle(pad_arr):
    if np.array(pad_arr.nonzero()).shape[1] > 2:
        if ((pad_arr[2, 0] != 0 and pad_arr[0, 1] != 0) or (pad_arr[2, 1] != 0 and pad_arr[0, 2] != 0)):
            return np.array([1, 2])
        elif (pad_arr[1, 0] != 0 and pad_arr[1, 2] != 0):
            return np.array([1, 0])
        elif ((pad_arr[1, 0] != 0 and pad_arr[0, 2] != 0) or (pad_arr[2, 0] != 0 and pad_arr[1, 2] != 0)):
            return np.array([2, 1])
        elif (pad_arr[0, 1] != 0 and pad_arr[2, 1] != 0):
            return np.array([0, 1])
        elif ((pad_arr[0, 0] != 0 and pad_arr[2, 1] != 0) or (pad_arr[0, 1] != 0 and pad_arr[2, 2] != 0)):
            return np.array([-1, 2])
        elif (pad_arr[0, 2] != 0 and pad_arr[2, 0] != 0):
            return np.array([1, 1])
        elif ((pad_arr[0, 0] != 0 and pad_arr[1, 2] != 0) or (pad_arr[1, 0] != 0 and pad_arr[2, 2] != 0)):
            return np.array([-2, 1])
        else:
            return np.array([-1, 1])
    else:
        if (pad_arr[0, 0] != 0 or pad_arr[2, 2] != 0):
            return np.array([-1, 1])
        elif (pad_arr[0, 1] != 0 or pad_arr[2, 1] != 0):
            return np.array([0, 1])
        elif (pad_arr[1, 0] != 0 or pad_arr[1, 2] != 0):
            return np.array([1, 0])
        else:
            return np.array([1, 1])


# In[11]:


def nearest(edge_img, pos):
    pad = edge_img[(pos[0] - 1):(pos[0] + 2), (pos[1] - 1):(pos[1] + 2)]
    pad[1][1] = 0
    if (pad == 0).all():
        return False
    else:
        return True

    
# In[12]:


def face_area_size(outline):
    Y_t, X_t = draw.polygon(outline[:, 1], outline[:, 0])
    return Y_t.shape[0]



class FeaturesDataset(Dataset):
    
    def __init__(self,featlst,labellst):
        self.featlst = featlst
        self.labellst = labellst
        
    def __getitem__(self,index):
        return (self.featlst[index],self.labellst[index])
    
    def __len__(self):
        return len(self.labellst)