# dmfa_inpainting

Source code for **MisConv: Convolutional Neural Networks forMissing Data**.

## Requirements

Python 3.8 or higher is recommended.
Models have been implemented with PyTorch.

To install the requirements, running:

```bash
pip install -r requirements.txt
```

should suffice.

### External (optional) dependencies

* for running classical / shallow MFA models, clone https://github.com/eitanrich/torch-mfa next to this folder.
* for running ACFlow, clone https://github.com/lupalab/ACFlow next to this folder
* for running Partial Convolutions clone next to this folder https://github.com/NVIDIA/partialconv
* for running K-NN inpainter, install https://github.com/rapidsai/cuml library

## Running

All scripts should be run from within `scripts/` directory.

We provide `train_inpainter.py`, `train_classifier_v2.py` and `train_wae_v2.py` for 
training DMFA, classifiers and WAEs, respectively.

### Reproducing

In `scripts/`, we also provide shell scripts, through which one can rerun the experiments reported in the paper.
