#!/usr/bin/env python3

import os.path as path
import pickle
import pprint

from pyNN.utility import get_simulator

from sarnn.pynn import PyNNModel

i = 4

sim, _ = get_simulator()
model = PyNNModel.load(path.join("models", "hbp", "base.p"))
model.build(sim)

with open(path.join("data", "mnist_test.p"), "rb") as pickle_file:
    data = pickle.load(pickle_file)

# Parameters chosen to match experiments/evaluate_snn/hbp_base.sh
results = model.evaluate(
    data["x"][100 * i: 100 * (i + 1)], data["y"][100 * i: 100 * (i + 1)],
    acc_ann=0.986400,  # From results/evaluate_ann/hbp_base.csv
    threshold=0.98,
    v_initial=0.0,
    n_time_steps=100)

# Put this in a CSV file manually...
pprint.pprint(results)
with open("evaluate_hbp_base_{}.p".format(i), "wb") as pickle_file:
    pickle.dump(results, pickle_file)
