#!/usr/bin/env bash

#SBATCH --cpus-per-task=2
#SBATCH --gpus-per-task=1
#SBATCH --job-name=mobilenet_base
#SBATCH --mem-per-cpu=8GB
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=4
#SBATCH --output=results/evaluate_snn/mobilenet_base.csv
#SBATCH --partition=batch_default
#SBATCH --requeue
#SBATCH --time=5-00:00:00

ARGS="
    --ann-filename models/ann/mobilenet_imagenet.h5
    --threshold 0.48
    --v-initial 0.0
    --ranks-per-node 4
    --n-time-chunks 500
"

mpirun -n 4 ./scripts/evaluate_snn.py \
    ./models/snn/mobilenet_imagenet.h5 \
    $ARGS
