#!/usr/bin/env python3

import numpy as np

# This is all pretty slow, but it only has to run once...

# Range of incoming currents to sample
dv = np.linspace(0.0, 1.0, num=50001)

# Number of time steps to simulate
t_max = 10000

# Test a range of values of v_0
for v_0 in np.linspace(0.0, 1.0, num=100, endpoint=False):

    # Temporal mean of v for all values of dv
    t_mean = np.zeros_like(dv)

    for t in range(t_max):
        x = v_0 + dv * t
        t_mean += (x - np.floor(x)) / float(t_max)

    print("V_0: {:.2f}; mean: {:.4f}".format(v_0, np.mean(t_mean)), flush=True)
