#!/usr/bin/env python3

import os.path as path
import time

import pyNN.neuron as sim

from sarnn.pynn import PyNNModel
from sarnn.utils import load_model
from snn.utils import load_snn_dataset

(x, y), _ = load_snn_dataset("mnist", "test")

snn = load_model(path.join("models", "snn", "dense_mnist.h5"))
snn_pynn = PyNNModel.from_keras(snn)
snn_pynn.build(sim)

print('Starting simulation...')
t_1 = time.time()
snn_pynn.evaluate(x[:1000], y[:1000], v_initial=0.0, n_time_steps=50)
t_2 = time.time()
print('Simulation finished.')
print("Elapsed: {}".format(t_2 - t_1))
