#!/usr/bin/env python3

import os
import os.path as path

import numpy as np

from snn.utils import load_snn_dataset

(x_train, y_train), _ = load_snn_dataset("mnist", "train")
(x_test, y_test), _ = load_snn_dataset("mnist", "test")

base = path.join("experiments", "time", "snn-tb_data", "mnist")
os.makedirs(base, exist_ok=True)

np.savez_compressed(path.join(base, "x_train.npz"), x_train)
np.savez_compressed(path.join(base, "y_train.npz"), y_train)
np.savez_compressed(path.join(base, "x_test.npz"), x_test)
np.savez_compressed(path.join(base, "y_test.npz"), y_test)
np.savez_compressed(path.join(base, "x_norm.npz"), x_train)
