#!/usr/bin/env bash

# Validate argument count
if [ $# -ne 4 ]
then
    echo 'Usage: prepare_hbp.sh <zip_file> <experiment_script> <model_file> <data_file>'
    exit 1
fi

# Don't overwrite/append to an existing ZIP
if [ -e "$1" ]
then
    echo "Error: \"$1\" already exists"
    exit 1
fi

# Work with absolute path since we'll be moving around the filesystem
ZIP_FILE="$(realpath "$1")"

# Add library files to the ZIP
cd sarnn || exit 1
zip -r "$ZIP_FILE" sarnn/{__init__,metrics,pynn}.py || exit 1
cd ..

# Add the experiment script to the ZIP
chmod u+x "$2"
START="$(pwd)"
cd "$(dirname "$2")" || exit 1
zip "$ZIP_FILE" "$(basename "$2")" || exit 1
cd "$START"

# Add the model and data files to the ZIP
zip "$ZIP_FILE" "$3" "$4" || exit 1

# Copy to the remote machine (destination directory must already exist)
scp "$ZIP_FILE" "dutson@spike.cs.wisc.edu:/u/d/u/dutson/public/html/hbp/$(basename $ZIP_FILE)" || exit 1
