import argparse
import os
from ..util import util

class BaseOptions():
    def __init__(self):
        self.parser = argparse.ArgumentParser()
        self.initialized = False

    def initialize(self):
        self.parser.add_argument('-imask', type=str, default='')
        self.parser.add_argument('-step', type=int, default=1)
        self.parser.add_argument('--sparsity', type=float, default=0.5)
        self.parser.add_argument('-initialized', action='store_true')
        self.parser.add_argument('-conv_sparse', type=str, default='')
        self.parser.add_argument('-dataset', type=str, default='CIFAR_10')
        self.parser.add_argument('-type_sparse', type=str, default='')
        self.parser.add_argument('-use_dynamic', action='store_true')
        self.parser.add_argument('--temperature', default=31, type=int, help='temperature')
        self.parser.add_argument('--lr', default=0.1, type=float, help='learning rate')
        self.parser.add_argument('--resume', '-r', action='store_true', help='resume from checkpoint')
        self.parser.add_argument('--log', action='store_true')
        self.parser.add_argument('--isTrain', action='store_true')
        self.parser.add_argument('--nof_kernels', type=int, default=4)
        self.parser.add_argument('--reduce', type=int, default=4)
        self.parser.add_argument('-reduction', type=int, default=4)
        self.parser.add_argument('-weight_decay', type=float, default=5e-4)
        self.parser.add_argument('--checkpoints_dir', type=str, default='./checkpoints', help='models are saved here')


    def parse(self, save=True):
        if not self.initialized:
            self.initialize()
        self.opt = self.parser.parse_args()

        str_ids = self.opt.gpu_ids.split(',')
        self.opt.gpu_ids = []
        for str_id in str_ids:
            id = int(str_id)
            if id >= 0:
                self.opt.gpu_ids.append(id)

        # set gpu ids

        args = vars(self.opt)

        # save to the disk
        expr_dir = os.path.join(self.opt.checkpoints_dir, self.opt.model)
        util.mkdirs(expr_dir)
        if save and not self.opt.continue_train:
            file_name = os.path.join(expr_dir, 'opt.txt')
            with open(file_name, 'wt') as opt_file:
                opt_file.write('------------ Options -------------\n')
                for k, v in sorted(args.items()):
                    opt_file.write('%s: %s\n' % (str(k), str(v)))
                opt_file.write('-------------- End ----------------\n')
        return self.opt
