# PointNeuron: 3D Neuron Reconstruction via the Geometry and Topology Learning of Point Clouds

# Installation

You need to manually install the following primary packages before running this demo:

* `Python == 3.7.11`
* `PyTorch == 1.8.0`
* `Numpy == 1.20.3`
* `scipy == 1.7.1`
* `tqdm == 4.62.3`
* `scikit-fmm == 2022.3.26`
* `open3d == 0.11.2`

Installing Pytorch through `conda install`

```
conda install pytorch==1.8.0 torchvision==0.9.0 torchaudio==0.8.0 cudatoolkit=10.2 -c pytorch
```

The code is only tested on NVIDIA GeForce RTX 2080 Ti.

# Introduction

This demo demonstrates the inference procedure of our work. Based on the pre-trained models, we pick a test image as a sample to go through all of the steps of *PointNeuron* that are presented in the paper, including voxel-to-point transformation, neuron skeleton prediction, and neuron connectivity prediction. The task-specified software tool, [Vaa3D](https://github.com/Vaa3D), is not required for demo running. Also, this sample and all of the training data are obtained from [BigNeuron](https://github.com/BigNeuron) challenge dataset.

# Run demo

You can run this demo by:

```console
cd PointNeuron_supplemental_material_revision/code
python ./demo.py
```

This demo uses the pre-trained models to predict the neuron skeleton and its connectivity for this sample neuron. The raw 3D microscopy image is under `./data` folder. The point cloud outputs are saved in "xxx.ply" files, so you can easily use the 3D visualization software such as [CloudCompare](https://www.danielgm.net/cc/) to display the neuron input points and the skeletal points under `./result` folder. "xxx.swc" file is better to be visualized in Vaa3D.

# Visualization

The noisy neuron input points ("neuron_input_pts.ply") are transmitted into the compact neuron skeleton ("neuron_skel.ply"), which makes the geometric structure more clear:

![1657892609167](image/README/1657892609167.png)

The reconstructed neuron morphology is saved in "neuron_reconst.swc":

![1657885995228](image/README/1657885995228.png)
