import os
import sys

sys.path.append("../../")
import roadscene2vec.data.proc.real_preprocessor as ip
from roadscene2vec.util.config_parser import configuration

'''This script runs pre-processing of Real data'''
def preprocess_data():
    data_config = configuration(sys.argv[1:])
    if data_config.dataset_type == "image":
        img_preproc = ip.RealPreprocessor(data_config)
        img_preproc.load()
        base_ds = img_preproc.getDataSet()
    else:
        raise ValueError("Please input a valid dataset type")

    os.makedirs(os.path.dirname(data_config.location_data['data_save_path']), exist_ok=True)           
    base_ds.save()
    
if __name__ == "__main__":
    preprocess_data()
    
   
   
   