This is the source code for the paper "Learning Regularity in Skeleton Trajectories for Anomaly Detection in Videos". It has been tested on Ubuntu 16 and 18 systems.

# Environment Setup
First please create an appropriate environment using conda: 

> conda env create -f environment.yml

> conda activate tbad

If you get any errors about not being able to install a few packages (e.g. torchvision, mkl-random), please ignore them and activate tbad.

# Test Pre-Trained Models
To evaluate pre-trained models run the `evaluate.py` script. Unfortunately, due to space requirements, we are not able to provide the extracted features for the testing sets in this supplementary matterial.
However, you can download it from this link https://bit.ly/2WGHz56. Please extract the `data.zip` file inside the `code` folder. If the given link has expired, please follow the instructions in training a model from scratch to extract the features for the testing set as well.

Some examples:

#### Evaluate MPED-RNN on all cameras individually and all cameras combined on HR-ShanghaiTech.
> python evaluate.py --gpu_ids 0 --gpu_memory 0.5 combined_models ./pretrained/CVPR19/ShanghaiTech/combined_model/_mp_Grobust_Lrobust_Orobust_concatdown_
 ../data/HR-ShanghaiTech/testing/trajectories ../data/HR-ShanghaiTech/testing/frame_level_masks --video_resolution 856x480 --overlapping_trajectories

#### Evaluate MPED-RNN on HR-Avenue.
> python evaluate.py --gpu_ids 0 --gpu_memory 0.5 combined_model ./pretrained/CVPR19/Avenue/combined_model/_mp_Grobust_Lrobust_Orobust_concatdown_/01_2018_11_13_06_36_20 
../data/HR-Avenue/testing/trajectories/01 ../data/HR-Avenue/testing/frame_level_masks/01 --video_resolution 640x360 --overlapping_trajectories

If you run into any GPU memory problem try to increase the `--gpu_memory value`. In our experiments, 2GB of GPU memory was usually enough to run the experiments.

# Train a Model from Scratch
Due to space requirements we were not able to provide the extracted features for the training sets. However, those could be obtained by following these instructions:

1. Download the original Avenue (http://www.cse.cuhk.edu.hk/leojia/projects/detectabnormal/dataset.html) or ShanghaiTech (https://github.com/StevenLiuWen/sRNN_TSC_Anomaly_Detection) dataset.
2. Install AlphaPose from https://github.com/MVIG-SJTU/AlphaPose/tree/pytorch and run it on the desired dataset.
3. Use tracking code provided in the folder code/tracking to track the skeletons output by AlphaPose.

The tracking code provided receives as input the .json file output by AlphaPose and generates a .csv file containing the tracked trajectory of each skeleton detected by AlphaPose. The commands to execute the tracking code are (change your current directory to the tracking folder):

> conda env create -f environment.yml

> conda activate tracking

> python main.py track <JSON_FILE_PATH> <VIDEO_FRAMES_PATH> --video_resolution <WIDTHxHEIGHT> --detection_quantile 10 --keypoint_confidence_threshold 0.30 --minimum_keypoints 7 --look_back 5 --bounding_box_edge_ratio 0.20 --matching_threshold 0.00 --write_tracking <CSV_FILE_NAME_TO_WRITE_RESULTS>

> python main.py split_and_pad <PATH_TO_CSV_FILE_GENERATED_IN_PREVIOUS_STEP> --write_split_trajectories <DIRECTORY_TO_WRITE_OUT_ALL_TRAJECTORIES_EXTRACTED>

Substitute the <> by appropriate paths.


