%% COMPUTE DERIVATIVES WITH RESPECT TO CENTER POSITIONS

clc
clear 
close all

%% build membranes

f1_c1 = [10.5720; -0.7300; -0.6647];
f1_l = 60;
f1_theta1 = 0.0;
f1_theta2 = 0.0;
f1_R = makehgtform('axisrotate', [1;0;0], f1_theta1)*makehgtform('axisrotate', [0;1;0], f1_theta2);
f1_c2 = f1_R(1:3,1:3)* f1_l* [0;0;1] + f1_c1 ;



f2_c1 = [65.5720; -0.7300; -0.6647];
f2_l = 60;
f2_theta1 = 0.0;
f2_theta2 = 0.0;
f2_R = makehgtform('axisrotate', [1;0;0], f2_theta1)*makehgtform('axisrotate', [0;1;0], f2_theta2);
f2_c2 = f2_R(1:3,1:3)* f2_l* [0;0;1] + f2_c1;


f1_r1 = 10.1;
f1_r2 = 9;

f2_r1 = 10.0;
f2_r2 = 9;


%% COMPUTE MEMBRANE CENTER POSITION OF FIRST FINGER
f1_s = 0.5;
f1_rm = 2.0;

location1 = f1_c1 + f1_s*(f1_c2 - f1_c1);
d1  = f1_R(1:3,1:3)*[0;-1;0];
location_ray1 = (1-f1_s)*f1_r1 + f1_s*f1_r2;
f1_cm = location1 + d1* (location_ray1-f1_rm);

%% COMPUTE MEMBRANE CENTER POSITION OF SECOND FINGER
f2_s = 0.5;
f2_rm = 2.0;

location2 = f2_c1 + f2_s*(f2_c2 - f2_c1);
d2  = f2_R(1:3,1:3)*[0;-1;0];
location_ray2 = (1-f2_s)*f2_r1 + f2_s*f2_r2;
f2_cm = location2 + d2* (location_ray2-f2_rm);


%% SET UP MODEL

centers = {f1_c1,f1_c2,f2_c1,f2_c2,f1_cm,f2_cm};
radii = {f1_r1,f1_r2,f2_r1,f2_r2, f1_rm,f2_rm};

blocks = {[1, 2], [3 , 4], [1,6,5], [1,6,3] };
%blocks = {[1,3],[6,3],[1,6] };
%blocks = {[1,3,6] };
%blocks = {[1,5,6]};


% reindex stuff
[blocks] = reindex(radii, blocks);


%% data point

data_points = { [43.5720; -20.7300; 25.6647] };

%% compute projection

[indices, model_points, block_indices] = compute_projections_debug(data_points, centers,radii,blocks);

indices{1}
block_indices{1}

%% display model & points

display_model_debug(centers,blocks,radii, 0.9, 'big')
mypoints(data_points, [0.3, 0.8, 0.3], 20);
mypoints(model_points, [0.3, 0.3, 0.8], 20);
mylines(data_points, model_points, [0.85, 0.85, 0.85]);

0

%% COMPUTE ANALYTICAL DERIVATIVES WITH FUNCTION

c1 = centers{blocks{block_indices{1}}(1)};
c2 = centers{blocks{block_indices{1}}(2)};
c3 = centers{blocks{block_indices{1}}(3)};
r1 = radii{blocks{block_indices{1}}(1)};
r2 = radii{blocks{block_indices{1}}(2)};
r3 = radii{blocks{block_indices{1}}(3)};

variables = {'c1', 'c2', 'c3','r1','r2','r3'};

[v1, v2, v3, Jv1, Jv2, Jv3, u1, u2, u3, Ju1, Ju2, Ju3] = jacobian_tangent_plane(c1, c2, c3, r1, r2, r3, variables);
if(indices{1}(1) > 0)
    [q, dq] = jacobian_convtriangle(data_points{1}, v1, v2, v3, Jv1, Jv2, Jv3, variables);
else
    [q, dq] = jacobian_convtriangle(data_points{1}, u1, u2, u3, Ju1, Ju2, Ju3, variables);
end

variables = {'c1','c2','beta1','beta2','r11','r12','r21','r22','s1','s2','theta11', 'theta12', 'theta21', 'theta22'};

c1 = f1_c1;
c2 = f2_c1;
beta1 = f1_l;
beta2 = f2_l;
R1 = f1_R;
R2 = f2_R;
r11 = f1_r1;
r12 = f1_r2;
r21 = f2_r1;
r22 = f2_r2;
s1 = f1_s;
s2 = f2_s;

[m_dc1, m_dc2, m_dcm1, m_dcm2, m_dc1_r, m_dc2_r, m_dcm1_r, m_dcm2_r ] = jacobian_membrane( c1b,c2b,c1,c2, beta1, beta2, R1, R2, r11, r12, r21, r22, s1, s2, variables);

% if we are projecting over membrane block
if (block_indices{1} == 4)
    
    if length(indices{1} == 3)
      dc1 = m_dc1;
      
        
    end   
elseif (block_indices{1} == 3)
    
    if length(indices{1} == 3)       
        
    end    
end

%% F1C1 : compute numerical derivative
% 
epsilon = 1e-05;
J_F1C1_NUM = [];

for i = 1 : 3
direction = zeros(3,1);
direction(i)=1.0;
    
f1_c1_plus = f1_c1 + epsilon*direction;
f1_c2_plus = f1_R(1:3,1:3)* f1_l* [0;0;1] + f1_c1_plus ;
location1_plus = f1_c1_plus + f1_s*(f1_c2_plus - f1_c1_plus);
f1_cm_plus = location1_plus + d1* (location_ray1-f1_rm);
centers_plus = {f1_c1_plus,f1_c2_plus,f2_c1,f2_c2,f1_cm_plus,f2_cm};
[~, model_points_plus, ~] = compute_projections_debug(data_points, centers_plus,radii,blocks);

f1_c1_minus = f1_c1 - epsilon*direction;
f1_c2_minus = f1_R(1:3,1:3)* f1_l* [0;0;1] + f1_c1_minus ;
location1_minus = f1_c1_minus + f1_s*(f1_c2_minus - f1_c1_minus);
f1_cm_minus = location1_minus + d1* (location_ray1-f1_rm);
centers_minus = {f1_c1_minus,f1_c2_minus,f2_c1,f2_c2,f1_cm_minus,f2_cm};
[~, model_points_minus, ~] = compute_projections_debug(data_points, centers_minus,radii,blocks);

J_F1C1_NUM = [J_F1C1_NUM, (model_points_plus{1} - model_points_minus{1})/(2*epsilon)];

end

J_F1C1_NUM

