clear
load counter_data


%stating from three random rotations: R_star,R2, R3 s.t R_star-R3 is rank 2. 

M=R_star-R3;

[u,d,v]=svd(M);
f1=u(:,1)*d(1,1)*v(:,1)';
f2=u(:,2)*d(2,2)*v(:,2)';

%define t3 as the position of the third camera:
t3=u(:,1)*d(1,1);
a=v(:,1);

%define t3-t2 as t3_t2
t2=t3-u(:,2)*d(2,2);
b=v(:,2);

%now we can see that R_star-R3=(t3*a'+(t3-t2)*b') => R2(R2^T)R_star=R3+(t3*a'+(t3-t2)*b')
%so the following is a rotation:

disp('Equal Singular Values')
svd(R3+(t3*a'+(t3-t2)*b'))


disp('Should be zero')
norm(R2'*(R3+(t3*a'+(t3-t2)*b'))-R2'*R_star,'fro')



%So define:
V1=eye(3);
V2=R2';
t1=0;
V3=(R3+t3*a')';



E12=getCrossM(-t2)*R2;

%E13 equals E13_2
E13=getCrossM(-t3)*R3;
E13_2=getCrossM(-t3)*V3';
disp('Should be zero')
norm(E13-E13_2,'fro')


%E23 equals E23_2 
E23=V2*getCrossM(t2-t3)*V3';
E23_2=getCrossM(V2*(t2-t3))*V2*V3';
disp('Should be zero')
norm(E23-E23_2,'fro')


%V2*V3' is not rotation, but E23 is essential matrix using R_star:
E23_3=getCrossM(V2*(t2-t3))*R2'*R_star;


%Define the multiview fundamental matrix F
V_big=[eye(3); R2'; V3];
U_big=[eye(3)*getCrossM(zeros(3,1)); R2'*getCrossM(t2); V3*getCrossM(t3)];
F=V_big*U_big'+U_big*V_big';


%So here F is consistent, and all are essentials but the essentials are not
%consistent

disp('Should be zero')
norm(F(1:3,4:6)-E12,'fro')
disp('Should be zero')
norm(F(1:3,7:9)-E13,'fro')
disp('Should be zero')
norm(F(4:6,7:9)-E23,'fro')

disp('E12 Should have two identical sigular values')
svd(E12)
disp('E13 Should have two identical sigular values')
svd(E13)
disp('E13 Should have two identical sigular values')
svd(E23)

disp('F is rank 6')
% log10(svd(F))
(svd(F))


 isEigenBlockRot( F )

 
 isLoopClosed( F )
 