/*
 * Globally-Optimal Gaussian Mixture Alignment (GOGMA): l2_cost_function
 * L2 cost function for rigid registration. Required for VNL LBFGSB optimiser.
 *
 * Campbell, D., and Petersson, L., "GOGMA: Globally-Optimal Gaussian
 * Mixture Alignment", IEEE Conference on Computer Visision and
 * Pattern Recognition (CVPR), Las Vegas, USA, IEEE, Jun. 2016
 *
 * For the full license, see license.txt in the root directory
 *
 * Author: Dylan Campbell
 * Date: 20160212
 * Revision: 1.1
 */

#ifndef L2_COST_FUNCTION_H_
#define L2_COST_FUNCTION_H_

#include <vnl/vnl_vector.h>
#include <vnl/vnl_matrix.h>
#include <vnl/vnl_cost_function.h>
#include "gogma.h"

class GOGMA; // Forward declare GOGMA class

class L2CostFunction : public vnl_cost_function {
public:
	// Constructors
	L2CostFunction();

	// Destructors
	~L2CostFunction() {}

	// Accessors
  int dimension() const {return dimension_;}
  double sigma_x() const {return sigma_x_;}
  double sigma_y() const {return sigma_y_;}
  vnl_matrix<double> gradient() const {return gradient_;}
  GOGMA* gogma() const {return gogma_;}

	// Mutators
  void set_dimension(int dimension) {dimension_ = dimension;}
	void set_sigma_x(double sigma_x) {sigma_x_ = sigma_x;}
	void set_sigma_y(double sigma_y) {sigma_y_ = sigma_y;}
	void set_gradient(vnl_matrix<double> gradient) {gradient_ = gradient;}
	void set_gogma(GOGMA* gogma) {gogma_ = gogma;}

	// Class Functions
	void Initialise(GOGMA* gogma);
	double f(const vnl_vector<double>& theta);
  void gradf(const vnl_vector<double>& theta, vnl_vector<double>& fgrad);

private:
  int dimension_;
  float sigma_x_;
  float sigma_y_;
  vnl_matrix<double> gradient_;
  GOGMA* gogma_;
};

#endif /* L2_COST_FUNCTION_H_ */
