/*
 * Globally-Optimal Gaussian Mixture Alignment (GOGMA): string_tokenizer
 * Parse strings from the config file.
 *
 * Campbell, D., and Petersson, L., "GOGMA: Globally-Optimal Gaussian
 * Mixture Alignment", IEEE Conference on Computer Visision and
 * Pattern Recognition (CVPR), Las Vegas, USA, IEEE, Jun. 2016
 *
 * For the full license, see license.txt in the root directory
 *
 * Author: Dylan Campbell
 * Date: 20160212
 * Revision: 1.1
 */

#include <iostream>
#include "string_tokenizer.h"

StringTokenizer::StringTokenizer() {
};

StringTokenizer::StringTokenizer(std::string str, char delim) {
  int delim_loc;
  while ((delim_loc = str.find_first_of(delim,0)) != std::string::npos) {
    if (str.substr(0, delim_loc).length() > 0) {
      tokens.push_back(str.substr(0,delim_loc));
    }
    str = str.substr(delim_loc+1, str.length());
  }
  if (str.length() > 0) {
    tokens.push_back(str);
  }
};

StringTokenizer::StringTokenizer(std::string str, char * delims) {
  int delim_loc;
  while ((delim_loc = str.find_first_of(delims,0)) != std::string::npos) {
    if (str.substr(0, delim_loc).length() > 0) {
      tokens.push_back(str.substr(0,delim_loc));
    }
    str = str.substr(delim_loc+1, str.length());
  }
  if (str.length() > 0) tokens.push_back(str);
};

StringTokenizer::~StringTokenizer() {
};

std::string StringTokenizer::nextToken() {
  if (!hasMoreTokens()) return "";
  std::string return_str(tokens.front());
  tokens.pop_front();
  return return_str;
};

bool StringTokenizer::hasMoreTokens() {
  return !tokens.empty();
};

int StringTokenizer::numberOfTokens() {
  return tokens.size();
};
