function model = kmilpAffineModel(match,th,M,matchk)

    N = size(match,2);

    X = [match(1:2,:)' ones(N,1)];
    y1 = match(3,:)';
    y2 = match(4,:)';
    M_N = M*ones(N,1);
    
    f = [ zeros(6,1) ; ones(N,1) ];
    A = [  X zeros(N,3) -diag(M_N) ;
          -X zeros(N,3) -diag(M_N) ;
          zeros(N,3)  X -diag(M_N) ;
          zeros(N,3) -X -diag(M_N) ];
    b = [ th+y1 ;
          th-y1 ; 
          th+y2 ; 
          th-y2 ];

    Xk = [matchk(1:2)' 1];
    yk1 = matchk(3);
    yk2 = matchk(4);
    
    A = [            A           ;
           Xk 0 0   0 zeros(1,N) ;
          -Xk 0 0   0 zeros(1,N) ;
            0 0 0  Xk zeros(1,N) ;
            0 0 0 -Xk zeros(1,N) ];
    b = [    b   ;
          th+yk1 ;
          th-yk1 ;
          th+yk2 ;
          th-yk2 ];

    model.A = A;
    model.obj = f;
    model.rhs = b;
    model.sense = repmat('<',4*N + 4,1);
    model.vtype = [ repmat('C',6,1) ;
                    repmat('B',N,1) ];
    model.lb = [ -Inf(6,1) ; zeros(N,1) ];
    model.ub = [  Inf(6,1) ;  ones(N,1) ];
    model.modelsense = 'min';

    vtype = [sum(model.vtype=='C') sum(model.vtype=='B')];
    model.vtype = int32(vtype);
    sense = -ones(length(model.sense),1);
    for i = 1:length(model.sense)
        if model.sense(i) == '<'
            sense(i) = -1;
        elseif model.sense(i) == '>'
            sense(i) = 1;
        else
            error('unable to interpret model.sense');
        end
    end
    model.sense = int32(sense);

end