function [lb_val,ub_val,best_sol] = milpFitAffine(match,th,M,maxtime,verb,matchk)

    N = size(match,2);

    X = [match(1:2,:)' ones(N,1)];
    y1 = match(3,:)';
    y2 = match(4,:)';
    M_N = M*ones(N,1);

    f = [ zeros(6,1) ; ones(N,1) ];
    A = [  X zeros(N,3) -diag(M_N) ;
          -X zeros(N,3) -diag(M_N) ;
          zeros(N,3)  X -diag(M_N) ;
          zeros(N,3) -X -diag(M_N) ];
    b = [ th+y1 ;
          th-y1 ;
          th+y2 ;
          th-y2 ];
      
    if ~isempty(matchk)
        Xk = [matchk(1:2)' 1];
        yk1 = matchk(3);
        yk2 = matchk(4);

        A = [            A           ;
               Xk 0 0   0 zeros(1,N) ;
              -Xk 0 0   0 zeros(1,N) ;
                0 0 0  Xk zeros(1,N) ;
                0 0 0 -Xk zeros(1,N) ];
        b = [    b   ;
              th+yk1 ;
              th-yk1 ;
              th+yk2 ;
              th-yk2 ];
    end

    % Use Gurobi.
    model.A = sparse(A);
    model.obj = f;
    model.rhs = b;
    if ~isempty(matchk)
        model.sense = repmat('<',4*N + 4,1);
    else
        model.sense = repmat('<',4*N,1);
    end
    model.vtype = [ repmat('C',6,1) ;
                    repmat('B',N,1) ];
    model.lb = [ -Inf(6,1) ; zeros(N,1) ];
    model.ub = [  Inf(6,1) ;  ones(N,1) ];
    model.modelsense = 'min';

    params.outputflag = verb;
    params.Cuts = 3;
    params.Threads = 4;
    params.TimeLimit = maxtime;
    %     params.IntFeasTol = 1e-9;
    %     params.FeasibilityTol = 1e-9;
    %     params.OptimalityTol = 1e-9;

    result = gurobi(model, params);

    if strcmp(result.status,'INFEASIBLE')
        lb_val = NaN;
        ub_val = NaN;
        best_sol = NaN(6,1);
    else
        lb_val = result.objbound;
        ub_val = result.objval;
        best_sol = result.x(1:6);
    end

end