%#ok<*ASGLU>
%#ok<*AGROW>
%#ok<*NASGU>
function [remI,sol,total_runtime] = GOREAffine(match,th,nocallback)

rng('shuffle');

% GORE parameters
M = 1000;         % Big-M.
T = 10;           % number of points to test. Approximately 0.1*N
c = 15;           % Time per test.

% Initial estimate for upper bound.
tic;
    [r_con_size,ransac_sol] = ransacFitAffine(match,th,10000);
runtime_ransac = toc;
N = size(match,2);
out_upper_bound = N - r_con_size;

r_aff = reshape(ransac_sol,3,2);
r = max(abs([match(1:2,:)' ones(N,1)]*r_aff - match(3:4,:)'),[],2);
[~,I] = sort(r,'descend');

% GORE.
runtime_gore = zeros(1,T);
numrem_gore = zeros(1,T);
remI = []; % index of points identified as true outliers    
for t=1:T
    k = I(t); % start with the worst outliers to ransac estimate
    
    matchk = match(:,k);
    matcht = match;
    matcht(:,[remI k]) = [];
    
    if nocallback
        tic;
            [lb_val,~,~] = milpFitAffine(matcht,th,M,c,0,matchk);
        runtime = toc;
    else
        model = kmilpAffineModel(matcht,th,M,matchk);
        tic;
            [lb_val,~,~] = maxcon_milp(model.vtype,model.A,model.sense,model.rhs,c,int32(out_upper_bound));
        runtime = toc;
    end
    
    if t == 1
        runtime_gore(t) = runtime;
    else
        runtime_gore(t) = runtime_gore(t-1) + runtime;
    end

    if lb_val > out_upper_bound
        remI = [remI k];
    end
    
    numrem_gore(t) = numel(remI);
    
    fprintf('GORE %d/%d: %d outlier(s) identified, total time elapsed: %f seconds.\n',t,T,length(remI),runtime_gore(t));
    
end

% Exact after GORE.
fprintf('Running MILP after preprocessing with GORE...\n');
matcht = match;
matcht(:,remI) = [];
tic;
    [lb,ub,sol] = milpFitAffine(matcht,th,M,inf,0,[]);
runtime_gored_exact = toc;
fprintf('MILP solved the pre-processed problem exactly in %f seconds.\n',runtime_gored_exact);

total_runtime = runtime_ransac + runtime_gore(end) + (runtime_gored_exact);

end