% dependencies: VLFEAT from http://www.vlfeat.org/

% arguments:
% filename1 and filename2 are strings specifying the images we wish to
%                         match
function match = readImages(filename1,filename2,vl_ubcmatch_threshold)

    img1 = imread(filename1);
    img2 = imread(filename2);
    img1 = imresize(img1,0.25);
    img2 = imresize(img2,0.25);
    if numel(size(img1)) == 3
        img1 = rgb2gray(img1);
    end
    if numel(size(img2)) == 3
        img2 = rgb2gray(img2);
    end
    [kp1,desc1] = vl_sift(single(img1));
    [kp2,desc2] = vl_sift(single(img2));
    inx = vl_ubcmatch(desc1,desc2,vl_ubcmatch_threshold);
    match = [kp1(1:2,inx(1,:));kp2(1:2,inx(2,:))];
    
%     figure;
%     showMatchedFeatures(img1,img2,match(1:2,:)',match(3:4,:)','montage');
end